/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.AbstractASN1CharacterString;
import com.bifit.security.asn1.CharConverter;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;

public class ASN1UTF8String
extends AbstractASN1CharacterString {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.UNIVERSAL, 12L);
    public static final ASN1Template TEMPLATE = new Template();

    public ASN1UTF8String(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    public ASN1UTF8String(String string) throws CharConversionException {
        super(string);
    }

    @Override
    protected CharConverter getCharConverter() {
        return new UTF8Converter();
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public static ASN1UTF8String getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1UTF8String)ASN1Util.decode(TEMPLATE, byArray);
    }

    private static class UTF8Converter
    implements CharConverter {
        private static final String ERROR_MESSAGE = "Unable to find UTF8 encoding mechanism";

        private UTF8Converter() {
        }

        @Override
        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            try {
                String string = new String(byArray, n, n2, "UTF8");
                return string.toCharArray();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.notReached(ERROR_MESSAGE);
                throw new CharConversionException(ERROR_MESSAGE);
            }
        }

        @Override
        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            try {
                String string = new String(cArray, n, n2);
                return string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.notReached(ERROR_MESSAGE);
                throw new CharConversionException(ERROR_MESSAGE);
            }
        }
    }

    public static class Template
    extends AbstractASN1CharacterString.AbstractTemplate
    implements ASN1Template {
        @Override
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new UTF8Converter();
        }

        @Override
        protected AbstractASN1CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new ASN1UTF8String(cArray);
        }

        @Override
        protected String typeName() {
            return "ASN1UTF8String";
        }
    }
}

