/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.AbstractASN1CharacterString;
import com.bifit.security.asn1.CharConverter;
import com.bifit.security.asn1.InvalidBERException;
import java.io.CharConversionException;

public class ASN1VisibleString
extends AbstractASN1CharacterString {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.UNIVERSAL, 26L);
    public static final ASN1Template TEMPLATE = new Template();

    public ASN1VisibleString(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    public ASN1VisibleString(String string) throws CharConversionException {
        super(string);
    }

    @Override
    protected CharConverter getCharConverter() {
        return new VisibleStringConverter();
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public static ASN1VisibleString getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1VisibleString)ASN1Util.decode(TEMPLATE, byArray);
    }

    private static class VisibleStringConverter
    implements CharConverter {
        private VisibleStringConverter() {
        }

        @Override
        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray[i] = (char)(byArray[n + i] & 0xFF);
            }
            return cArray;
        }

        @Override
        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            String string = new String(cArray, n, n2);
            byte[] byArray = new byte[string.length()];
            for (int i = 0; i != byArray.length; ++i) {
                char c = string.charAt(i);
                byArray[i] = (byte)c;
            }
            return byArray;
        }
    }

    public static class Template
    extends AbstractASN1CharacterString.AbstractTemplate
    implements ASN1Template {
        @Override
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new VisibleStringConverter();
        }

        @Override
        protected AbstractASN1CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new ASN1VisibleString(cArray);
        }

        @Override
        protected String typeName() {
            return "ASN1VisibleString";
        }
    }
}

