/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.GFp;
import com.bifit.security.core.SecurePRNG;
import com.bifit.security.core.Utils;
import java.util.Random;

public final class BigInt {
    private final int[] a;
    private final int[] b;
    private final int[] c;
    private final int[] d;
    private final int[] e;
    private final int[] f;
    private final int[] g;
    private final int[] h;
    private final int[] i;
    private final int[] j;
    private final int[] k;
    private final int[] l;
    private final int[] m;
    private final int[] n;
    private final int[] o;
    private long p;
    private long q;
    private final int r;
    private final int s;

    public BigInt(int n2) {
        this.r = n2;
        this.s = n2 - 1;
        this.a = new int[n2];
        this.b = new int[n2];
        this.c = new int[n2];
        this.b[this.s] = 1;
        this.c[this.s] = 2;
        this.d = new int[n2];
        this.e = new int[n2];
        this.g = new int[n2];
        this.f = new int[n2 << 1];
        this.h = new int[n2 << 1];
        this.j = new int[(n2 << 1) + 1];
        this.i = new int[n2];
        this.k = new int[n2];
        this.l = new int[n2];
        this.m = new int[n2];
        this.n = new int[n2];
        this.o = new int[n2];
    }

    public final int[] getZero() {
        return (int[])this.a.clone();
    }

    public final int[] getOne() {
        return (int[])this.b.clone();
    }

    public final int[] getTwo() {
        return (int[])this.c.clone();
    }

    public final void getRandomNumber(Random random, int[] nArray, int[] nArray2) {
        int n2 = BigInt.bitLength(nArray);
        int n3 = this.r - (n2 + 31 >>> 5);
        do {
            for (int i2 = this.r - 1; i2 >= n3; --i2) {
                nArray2[i2] = random.nextInt();
            }
            BigInt.truncate(nArray2, n2);
        } while (BigInt.compare(nArray2, nArray) >= 0 || BigInt.compare(nArray2, this.b) <= 0);
    }

    public final void getRandomNumber(SecurePRNG securePRNG, int[] nArray, int[] nArray2) {
        int n2 = BigInt.bitLength(nArray);
        int n3 = n2 + 31 >>> 5;
        do {
            securePRNG.a(nArray2, this.r - n3, n3);
            BigInt.truncate(nArray2, n2);
        } while (BigInt.compare(nArray2, nArray) >= 0 || BigInt.equals(nArray2, this.a));
    }

    public final void getRandomNumber(Random random, int n2, int[] nArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        int n3 = this.r - (n2 >>> 5);
        for (int i2 = this.r - 1; i2 >= n3; --i2) {
            nArray[i2] = random.nextInt();
            BigInt.truncate(nArray, n2);
        }
    }

    public final int add(int[] nArray, int[] nArray2, int[] nArray3) {
        long l2 = 0L;
        for (int i2 = this.s; i2 >= 0; --i2) {
            l2 = (l2 >>> 32) + ((long)nArray[i2] & 0xFFFFFFFFL) + ((long)nArray2[i2] & 0xFFFFFFFFL);
            nArray3[i2] = (int)l2;
        }
        return (int)(l2 >>> 32);
    }

    public static int add(int[] nArray, int n2) {
        long l2 = n2;
        for (n2 = nArray.length - 1; l2 != 0L && n2 >= 0; l2 >>= 32, --n2) {
            nArray[n2] = (int)(l2 += (long)nArray[n2] & 0xFFFFFFFFL);
        }
        return (int)l2;
    }

    public final int subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        long l2 = 0L;
        for (int i2 = this.s; i2 >= 0; --i2) {
            l2 = (l2 >> 32) + ((long)nArray[i2] & 0xFFFFFFFFL) - ((long)nArray2[i2] & 0xFFFFFFFFL);
            nArray3[i2] = (int)l2;
        }
        return (int)(l2 >> 32);
    }

    public final void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = (this.r << 1) - 2; i2 >= 0; --i2) {
            int n2 = i2 > this.s ? this.s : i2;
            int n3 = i2 - n2;
            while (n2 >= n3) {
                l2 = (l2 & 0xFFFFFFFFL) + ((long)nArray[i2 - n2] & 0xFFFFFFFFL) * ((long)nArray2[n2] & 0xFFFFFFFFL);
                l3 += l2 >>> 32;
                --n2;
            }
            nArray3[i2 + 1] = (int)l2;
            l2 = l3;
            l3 >>>= 32;
        }
        nArray3[0] = (int)l2;
    }

    public final void square(int[] nArray, int[] nArray2) {
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = (this.r << 1) - 2; i2 >= 0; --i2) {
            long l4;
            int n2 = (i2 + 1 >>> 1) - 1;
            int n3 = i2 - this.s;
            if (n3 < 0) {
                n3 = 0;
            }
            long l5 = 0L;
            l2 = 0L;
            while (n2 >= n3) {
                l4 = l2 & 0xFFFFFFFFL;
                l2 = l4 + ((long)nArray[i2 - n2] & 0xFFFFFFFFL) * ((long)nArray[n2] & 0xFFFFFFFFL);
                l5 += l2 >>> 32;
                --n2;
            }
            l2 = ((l2 & 0xFFFFFFFFL) << 1) + l3;
            l3 = (l5 << 1) + (l2 >>> 32);
            if ((i2 & 1) == 0) {
                l4 = (long)nArray[i2 >>> 1] & 0xFFFFFFFFL;
                l2 = (l2 & 0xFFFFFFFFL) + l4 * l4;
                l3 += l2 >>> 32;
            }
            nArray2[i2 + 1] = (int)l2;
        }
        nArray2[0] = (int)l3;
    }

    public final void squareRoot(int[] nArray, int[] nArray2) {
        BigInt.shiftRight(nArray, 0, 1, this.d);
        Utils.copy(nArray, this.e);
        Utils.copy(nArray, this.f);
        while (true) {
            this.divide(this.f, this.d, this.h, null);
            System.arraycopy(this.h, this.r, this.g, 0, this.r);
            int n2 = this.add(this.g, this.d, this.d);
            BigInt.shiftRight(this.d, n2, 1, this.d);
            if (BigInt.compare(this.e, this.d) <= 0) break;
            Utils.copy(this.d, this.e);
        }
        Utils.copy(this.e, nArray2);
    }

    public final void divide(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2;
        int n3 = Utils.wordLength(nArray2);
        Utils.copy(nArray, this.j);
        Utils.copy(nArray2, this.i);
        int n4 = this.r - n3;
        if (nArray3 != null) {
            Utils.copy(this.a, nArray3);
        }
        if ((n2 = 32 - BigInt.bitLength(this.i[n4])) > 0) {
            BigInt.shiftLeft(this.j, n2, this.j);
            BigInt.shiftLeft(this.i, n2, this.i);
        }
        int n5 = (this.r << 1) - n3 + 1;
        for (int i2 = 0; i2 < n5; ++i2) {
            long l2 = (long)this.j[i2] << 32 | (long)this.j[i2 + 1] & 0xFFFFFFFFL;
            long l3 = (long)this.i[n4] & 0xFFFFFFFFL;
            long l4 = l2;
            BigInt bigInt = this;
            if (l3 == 1L) {
                bigInt.p = l4;
                bigInt.q = 0L;
            }
            bigInt.p = (l4 >>> 1) / l3 << 1;
            bigInt.q = l4 - bigInt.p * l3;
            if (bigInt.q >= l3) {
                bigInt.q -= l3;
                if (bigInt.p < 0xFFFFFFFFL) {
                    ++bigInt.p;
                }
            }
            if (this.p == 0L) continue;
            if (n3 > 1 && (this.p >= 0x100000000L || (this.p * ((long)this.i[n4 + 1] & 0xFFFFFFFFL) ^ Long.MIN_VALUE) > ((this.q << 32) + ((long)this.j[i2 + 2] & 0xFFFFFFFFL) ^ Long.MIN_VALUE))) {
                --this.p;
                this.q += (long)this.i[n4] & 0xFFFFFFFFL;
                if (this.q < 0x100000000L && (this.p * ((long)this.i[n4 + 1] & 0xFFFFFFFFL) ^ Long.MIN_VALUE) > ((this.q << 32) + ((long)this.j[i2 + 2] & 0xFFFFFFFFL) ^ Long.MIN_VALUE)) {
                    --this.p;
                }
            }
            int n6 = n4;
            int[] nArray5 = this.i;
            l3 = this.p;
            int n7 = i2;
            int[] nArray6 = this.j;
            bigInt = this;
            long l5 = 0L;
            long l6 = 0L;
            int n8 = bigInt.s;
            int n9 = bigInt.r - n6 + n7;
            while (n8 >= n6) {
                l5 = ((long)nArray5[n8] & 0xFFFFFFFFL) * l3 + (l5 >>> 32) + (l6 >>> 63);
                l6 = ((long)nArray6[n9] & 0xFFFFFFFFL) - (l5 & 0xFFFFFFFFL);
                nArray6[n9] = (int)l6;
                --n8;
                --n9;
            }
            l6 = ((long)nArray6[n9] & 0xFFFFFFFFL) - (l5 >>> 32) - (l6 >>> 63);
            nArray6[n9] = (int)l6;
            if (!(l6 >= 0L)) {
                int n10 = n4;
                int[] nArray7 = this.i;
                n7 = i2;
                nArray6 = this.j;
                BigInt bigInt2 = this;
                long l7 = 0L;
                int n11 = bigInt2.s;
                int n12 = bigInt2.r - n10 + n7;
                while (n11 >= n10) {
                    l5 = ((long)nArray6[n12] & 0xFFFFFFFFL) + ((long)nArray7[n11] & 0xFFFFFFFFL) + l7;
                    nArray6[n12] = (int)l5;
                    l7 = l5 >>> 32;
                    --n11;
                    --n12;
                }
                int n13 = n12;
                nArray6[n13] = (int)((long)nArray6[n13] + l7);
                --this.p;
            }
            if (nArray3 == null) continue;
            nArray3[i2 + n3 - 1] = (int)this.p;
        }
        if (nArray4 != null) {
            if (n2 > 0) {
                BigInt.shiftRight(this.j, 0, n2, this.j);
            }
            System.arraycopy(this.j, this.r + 1, nArray4, 0, this.r);
        }
        Utils.clean(this.j);
        Utils.clean(this.i);
    }

    public final void gcd(int[] nArray, int[] nArray2, int[] nArray3) {
        Utils.copy(nArray, this.m);
        Utils.copy(nArray2, this.n);
        int n2 = BigInt.bitLength(nArray);
        int n3 = BigInt.bitLength(nArray2);
        if (n2 == 0) {
            Utils.copy(nArray2, nArray3);
            return;
        }
        if (n3 == 0) {
            Utils.copy(nArray, nArray3);
            return;
        }
        int n4 = 0;
        while (((this.m[this.s] | this.n[this.s]) & 1) == 0) {
            BigInt.shiftRight(this.m, 0, 1, this.m);
            BigInt.shiftRight(this.n, 0, 1, this.n);
            ++n4;
        }
        while ((this.m[this.s] & 1) == 0) {
            BigInt.shiftRight(this.m, 0, 1, this.m);
        }
        while (true) {
            if ((this.n[this.s] & 1) == 0) {
                BigInt.shiftRight(this.n, 0, 1, this.n);
                continue;
            }
            if (BigInt.compare(this.n, this.m) > 0) {
                this.subtract(this.n, this.m, this.n);
            } else {
                this.subtract(this.m, this.n, this.o);
                Utils.copy(this.n, this.m);
                Utils.copy(this.o, this.n);
            }
            BigInt.shiftRight(this.n, 0, 1, this.n);
            if (BigInt.equals(this.n, this.a)) break;
        }
        BigInt.shiftLeft(this.m, n4, nArray3);
    }

    public final void getNAF(int[] nArray, int n2, int[] nArray2) {
        int n3;
        int n4 = 1 << n2;
        n2 = -1 >>> -n2;
        int n5 = n2 >>> 1;
        Utils.copy(nArray, this.k);
        Utils.copy(this.a, this.l);
        int n6 = 0;
        while (!BigInt.equals(this.k, this.a)) {
            n3 = this.k[this.s];
            int n7 = 0;
            if ((n3 & 1) == 1) {
                if ((n3 &= n2) > n5) {
                    nArray2[n6] = n3 - n4;
                    this.l[this.s] = -nArray2[n6];
                    n7 = this.add(this.k, this.l, this.k);
                } else {
                    nArray2[n6] = n3;
                    int n8 = this.s;
                    this.k[n8] = this.k[n8] & ~n2;
                }
            } else {
                nArray2[n6] = 0;
            }
            BigInt.shiftRight(this.k, n7, 1, this.k);
            ++n6;
        }
        for (n3 = this.r << 5; n3 >= n6; --n3) {
            nArray2[n3] = 0;
        }
        Utils.clean(this.k);
        Utils.clean(this.l);
    }

    public static boolean isPrime(int[] nArray) {
        int n2 = nArray.length;
        int n3 = nArray.length - 1;
        if (n2 == 1) {
            if (nArray[n3] == 0 || nArray[n3] == 1) {
                return false;
            }
            if (nArray[n3] == 2 || nArray[n3] == 3) {
                return true;
            }
        }
        GFp gFp = new GFp(nArray);
        BigInt bigInt = gFp.getBigInt();
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        bigInt.subtract(nArray, bigInt.b, nArray2);
        Utils.copy(nArray2, nArray3);
        int n4 = 0;
        while (BigInt.getBit(nArray3, n4) == 0) {
            ++n4;
        }
        if (n4 == 0) {
            return false;
        }
        BigInt.shiftRight(nArray3, 0, n4, nArray3);
        Random random = new Random();
        for (int i2 = 0; i2 < 50; ++i2) {
            bigInt.getRandomNumber(random, nArray2, nArray4);
            gFp.modPow(nArray4, nArray3, nArray5);
            if (BigInt.equals(nArray5, bigInt.b) || BigInt.equals(nArray5, nArray2)) continue;
            int n5 = 0;
            while (++n5 < n4 && !BigInt.equals(nArray5, nArray2)) {
                gFp.square(nArray5, nArray5);
                if (!BigInt.equals(nArray5, bigInt.b)) continue;
                return false;
            }
            if (n5 != n4 || BigInt.equals(nArray5, nArray2)) continue;
            return false;
        }
        return true;
    }

    public static int shiftLeft(int[] nArray, int n2, int[] nArray2) {
        int n3 = n2 >>> 5;
        int n4 = 0;
        int n5 = nArray.length;
        int n6 = n5 - 1;
        if ((n2 & 0x1F) == 0) {
            if (n3 > 0 && n3 <= n5) {
                n4 = nArray[n3 - 1];
            }
            for (n5 = n3; n5 <= n6; ++n5) {
                nArray2[n5 - n3] = nArray[n5];
            }
        } else {
            if (n3 < n5) {
                n4 = nArray[n3] >>> -n2;
            }
            for (n5 = n3; n5 < n6; ++n5) {
                nArray2[n5 - n3] = nArray[n5] << n2 | nArray[n5 + 1] >>> -n2;
            }
            if (n3 <= n6) {
                nArray2[n6 - n3] = nArray[n6] << n2;
            }
        }
        for (n5 = n6; n5 > n6 - n3 && n5 > 0; --n5) {
            nArray2[n5] = 0;
        }
        return n4;
    }

    public static void shiftRight(int[] nArray, int n2, int n3, int[] nArray2) {
        int n4 = n3 >>> 5;
        int n5 = nArray.length;
        int n6 = n5 - 1;
        if ((n3 & 0x1F) == 0) {
            n6 -= n4;
            while (n6 >= 0) {
                nArray2[n6 + n4] = nArray[n6];
                --n6;
            }
            if (n4 > 0 && n4 <= n5) {
                nArray2[n4 - 1] = n2;
            }
        } else {
            n6 -= n4;
            while (n6 > 0) {
                nArray2[n6 + n4] = nArray[n6] >>> n3 | nArray[n6 - 1] << -n3;
                --n6;
            }
            if (n4 < n5) {
                nArray2[n4] = nArray[0] >>> n3 | n2 << -n3;
            }
            if (n4 > 0) {
                nArray2[n4 - 1] = n2 >>> n3;
            }
        }
        for (n6 = 0; n6 < n4 - 1 && n6 < n5; ++n6) {
            nArray2[n6] = 0;
        }
    }

    public static void truncate(int[] nArray, int n2) {
        int n3 = nArray.length - (n2 >>> 5) - 1;
        if (n3 < 0) {
            return;
        }
        n2 = (1 << n2) - 1;
        int n4 = nArray[n3];
        if (n2 == 0) {
            n2 = -1;
        }
        nArray[n3] = n4 &= n2;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = 0;
        }
    }

    public static int bitLength(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == 0) continue;
            return (nArray.length - i2 - 1 << 5) + BigInt.bitLength(nArray[i2]);
        }
        return 0;
    }

    public static int bitLength(int n2) {
        if (n2 < 32768) {
            if (n2 < 128) {
                if (n2 < 8) {
                    if (n2 < 2) {
                        if (n2 <= 0) {
                            if (n2 < 0) {
                                return 32;
                            }
                            return 0;
                        }
                        return 1;
                    }
                    if (n2 < 4) {
                        return 2;
                    }
                    return 3;
                }
                if (n2 < 32) {
                    if (n2 < 16) {
                        return 4;
                    }
                    return 5;
                }
                if (n2 < 64) {
                    return 6;
                }
                return 7;
            }
            if (n2 < 2048) {
                if (n2 < 512) {
                    if (n2 < 256) {
                        return 8;
                    }
                    return 9;
                }
                if (n2 < 1024) {
                    return 10;
                }
                return 11;
            }
            if (n2 < 8192) {
                if (n2 < 4096) {
                    return 12;
                }
                return 13;
            }
            if (n2 < 16384) {
                return 14;
            }
            return 15;
        }
        if (n2 < 0x800000) {
            if (n2 < 524288) {
                if (n2 < 131072) {
                    if (n2 < 65536) {
                        return 16;
                    }
                    return 17;
                }
                if (n2 < 262144) {
                    return 18;
                }
                return 19;
            }
            if (n2 < 0x200000) {
                if (n2 < 0x100000) {
                    return 20;
                }
                return 21;
            }
            if (n2 < 0x400000) {
                return 22;
            }
            return 23;
        }
        if (n2 < 0x8000000) {
            if (n2 < 0x2000000) {
                if (n2 < 0x1000000) {
                    return 24;
                }
                return 25;
            }
            if (n2 < 0x4000000) {
                return 26;
            }
            return 27;
        }
        if (n2 < 0x20000000) {
            if (n2 < 0x10000000) {
                return 28;
            }
            return 29;
        }
        if (n2 < 0x40000000) {
            return 30;
        }
        return 31;
    }

    public static int getBit(int[] nArray, int n2) {
        int n3 = n2 >>> 5;
        int n4 = nArray.length;
        if (n2 < 0 || n3 >= n4) {
            return 0;
        }
        return nArray[n4 - 1 - n3] >>> n2 & 1;
    }

    public static int compare(int[] nArray, int[] nArray2) {
        int n2;
        int n3 = Utils.wordLength(nArray);
        if (n3 != (n2 = Utils.wordLength(nArray2))) {
            if (n3 > n2) {
                return 1;
            }
            return -1;
        }
        int n4 = nArray.length;
        n3 = nArray.length - n3;
        n2 = nArray2.length - n2;
        while (n3 < n4) {
            if (nArray[n3] != nArray2[n2]) {
                if ((nArray[n3] ^ Integer.MIN_VALUE) > (nArray2[n2] ^ Integer.MIN_VALUE)) {
                    return 1;
                }
                return -1;
            }
            ++n3;
            ++n2;
        }
        return 0;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        int n2;
        int n3 = Utils.wordLength(nArray);
        if (n3 != (n2 = Utils.wordLength(nArray2))) {
            return false;
        }
        int n4 = nArray.length;
        n3 = nArray.length - n3;
        n2 = nArray2.length - n2;
        while (n3 < n4) {
            if (nArray[n3] != nArray2[n2]) {
                return false;
            }
            ++n3;
            ++n2;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(int[] nArray) {
        int n2 = 0;
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            n2 = n2 * 31 + nArray[i2];
        }
        return n2;
    }
}

