/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.DSAParametersGenerator;
import com.bifit.security.core.DSAParams;
import com.bifit.security.core.DSAPrivateKey;
import com.bifit.security.core.DSAPublicKey;
import com.bifit.security.core.GFp;
import java.security.SecureRandom;
import java.util.Random;

public class DSAKeyPairGenerator {
    private final SecureRandom a;
    private DSAPublicKey b = null;
    private DSAPrivateKey c = null;
    private DSAParams d = null;

    public DSAKeyPairGenerator(int n2, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 3072 || n2 % 64 != 0) {
            throw new IllegalArgumentException("strength must be from 512 - 3072 and a multiple of 64");
        }
        this.a = secureRandom;
        DSAParametersGenerator dSAParametersGenerator = new DSAParametersGenerator(n2, secureRandom);
        this.d = dSAParametersGenerator.generateParameters();
    }

    public DSAKeyPairGenerator(DSAParams dSAParams, SecureRandom secureRandom) {
        this.a = secureRandom;
        this.d = dSAParams;
    }

    public void generate() {
        int n2 = this.d.d();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        BigInt bigInt = new BigInt(n2);
        bigInt.subtract(this.d.b(), bigInt.getOne(), nArray2);
        bigInt.getRandomNumber((Random)this.a, nArray2, nArray);
        this.c = new DSAPrivateKey(this.d, nArray);
        this.b = DSAKeyPairGenerator.getPublicByPrivate(this.c);
    }

    public DSAPublicKey getPublic() {
        if (this.b == null) {
            throw new IllegalStateException("key pair were not generated");
        }
        return this.b;
    }

    public DSAPrivateKey getPrivate() {
        if (this.b == null) {
            throw new IllegalStateException("key pair were not generated");
        }
        return this.c;
    }

    public static DSAPublicKey getPublicByPrivate(DSAPrivateKey dSAPrivateKey) {
        DSAParams dSAParams = dSAPrivateKey.getParams();
        GFp gFp = new GFp(dSAParams.a());
        int[] nArray = new int[dSAParams.d()];
        gFp.modPow(dSAParams.c(), dSAPrivateKey.getInternalX(), dSAParams.e(), null, null, null, nArray);
        return new DSAPublicKey(dSAParams, nArray);
    }
}

