/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.DSAKey;
import com.bifit.security.core.DSAParams;
import com.bifit.security.core.GFp;
import com.bifit.security.core.Utils;

public class DSAPublicKey
extends DSAKey {
    private final int[] a;
    private int[][] b;

    DSAPublicKey(DSAParams dSAParams, int[] nArray) {
        super(dSAParams);
        this.a = Utils.copy(nArray);
    }

    public DSAPublicKey(DSAParams dSAParams, byte[] byArray) {
        super(dSAParams);
        this.a = Utils.fromByteArray(byArray, dSAParams.d());
    }

    public byte[] getY() {
        return Utils.toByteArray(this.a, 4 * Utils.wordLength(this.getParams().a()));
    }

    public synchronized void setOptLevel(int n2) {
        if ((n2 = Utils.getWidthByOptLevel(n2)) != 0) {
            GFp gFp = new GFp(this.getParams().a(), 2);
            int[] nArray = new int[this.getParams().d()];
            gFp.toInternalDomain(this.a, nArray);
            this.b = gFp.getCombPrecomp(nArray, n2);
            return;
        }
        this.b = null;
    }

    public synchronized void setOptData(byte[] byArray) {
        if (byArray != null) {
            GFp gFp = new GFp(this.getParams().a(), 2);
            this.b = gFp.importPrecomp(byArray);
            return;
        }
        this.b = null;
    }

    public synchronized byte[] getOptData() {
        if (this.b != null) {
            return GFp.exportPrecomp(this.getParams().a(), this.b);
        }
        return null;
    }

    final int[] a() {
        return this.a;
    }

    final synchronized int[][] b() {
        return this.b;
    }
}

