/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.DSTU4145ECParams;
import com.bifit.security.core.DSTU4145ECPrivateKey;
import com.bifit.security.core.DSTU4145ECPublicKey;
import com.bifit.security.core.GF2m;
import com.bifit.security.core.SecurePRNG;
import com.bifit.security.core.n;
import com.bifit.security.core.p;

public final class DSTU4145ECKeyPairGenerator {
    private final SecurePRNG a;
    private DSTU4145ECPrivateKey b = null;
    private DSTU4145ECPublicKey c = null;
    private final DSTU4145ECParams d;

    public DSTU4145ECKeyPairGenerator(DSTU4145ECParams dSTU4145ECParams, SecurePRNG securePRNG) {
        this.a = securePRNG;
        this.d = dSTU4145ECParams;
    }

    public final void generate() {
        int n2 = this.d.c().length;
        int n3 = BigInt.bitLength(this.d.c());
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        do {
            this.a.a(nArray);
            BigInt.truncate(nArray, n3 - 1);
        } while (BigInt.equals(nArray, nArray2));
        this.b = new DSTU4145ECPrivateKey(this.d, nArray);
        this.c = DSTU4145ECKeyPairGenerator.getPublicByPrivate(this.b);
    }

    public final DSTU4145ECPrivateKey getPrivate() {
        if (this.b == null) {
            throw new IllegalStateException("key pair were not generated");
        }
        return this.b;
    }

    public final DSTU4145ECPublicKey getPublic() {
        if (this.c == null) {
            throw new IllegalStateException("key pair were not generated");
        }
        return this.c;
    }

    public final DSTU4145ECParams getParams() {
        return this.d;
    }

    public static DSTU4145ECPublicKey getPublicByPrivate(DSTU4145ECPrivateKey object) {
        DSTU4145ECParams dSTU4145ECParams = ((DSTU4145ECPrivateKey)object).getParams();
        p p2 = new p(dSTU4145ECParams);
        n n2 = dSTU4145ECParams.d();
        object = ((DSTU4145ECPrivateKey)object).a();
        n n3 = new n(p2.a().getZero(), p2.a().getZero());
        p2.a(n2, (int[])object, n3);
        object = n3;
        GF2m.add(((n)object).a(), ((n)object).b(), ((n)object).b());
        return new DSTU4145ECPublicKey(dSTU4145ECParams, n3);
    }
}

