/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.DSTU4145ECParams;
import com.bifit.security.core.Utils;

public final class DSTU4145ECPrivateKey {
    private int[] a;
    private final DSTU4145ECParams b;

    public DSTU4145ECPrivateKey(DSTU4145ECParams dSTU4145ECParams, byte[] byArray) {
        int[] nArray = dSTU4145ECParams.c();
        int[] nArray2 = Utils.fromByteArray(byArray, nArray.length);
        if (BigInt.bitLength(nArray2) == 0 || Utils.byteLength(byArray) > 4 * nArray.length || BigInt.compare(nArray2, nArray) >= 0) {
            Utils.clean(nArray2);
            throw new IllegalArgumentException("condition 0 < d < n is not met");
        }
        this.b = dSTU4145ECParams;
        this.a = nArray2;
    }

    DSTU4145ECPrivateKey(DSTU4145ECParams dSTU4145ECParams, int[] nArray) {
        this.b = dSTU4145ECParams;
        this.a = nArray;
    }

    public final byte[] getD() {
        if (this.a == null) {
            throw new IllegalStateException("key was deallocated");
        }
        int n2 = BigInt.bitLength(this.b.c()) + 6 >>> 3;
        return Utils.toByteArray(this.a, n2);
    }

    public final DSTU4145ECParams getParams() {
        return this.b;
    }

    public final void free() {
        Utils.clean(this.a);
        this.a = null;
    }

    final int[] a() {
        if (this.a == null) {
            throw new IllegalStateException("key was deallocated");
        }
        return this.a;
    }
}

