/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.RSACipherNoPadding;
import com.bifit.security.core.RSAKey;
import com.bifit.security.core.Utils;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;

public final class RSACipherISO9796Padding {
    private int[] a;
    private int[] b;
    private static byte[] c = new byte[]{14, 3, 5, 8, 9, 4, 2, 15, 0, 13, 11, 6, 7, 10, 12, 1};
    private static byte[] d = new byte[]{8, 15, 6, 1, 5, 2, 11, 12, 3, 4, 13, 10, 14, 9, 0, 7};
    private final RSACipherNoPadding e;
    public static final int ENCRYPT = 0;
    public static final int DECRYPT = 1;
    private int f;
    private final ByteArrayOutputStream g = new ByteArrayOutputStream();
    private boolean h = false;
    private BigInt i;
    private int j = 0;
    private int k = 0;
    private int[] l;
    private int[] m;
    private int[] n;

    public RSACipherISO9796Padding() {
        this.e = new RSACipherNoPadding();
    }

    public final void init(int n2, RSAKey rSAKey, SecureRandom secureRandom) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("invalid mode specified");
        }
        if (rSAKey == null) {
            throw new IllegalArgumentException("invalid key");
        }
        if (secureRandom == null) {
            throw new IllegalArgumentException("invalid random source");
        }
        this.e.init(n2, rSAKey, secureRandom);
        this.l = rSAKey.a();
        this.j = BigInt.bitLength(this.l);
        this.f = n2;
        this.h = true;
        n2 = rSAKey.getSize();
        int n3 = n2 >>> 1;
        this.m = new int[n3];
        this.n = new int[n2];
        this.a = new int[n3];
        this.a[n3 - 1] = 6;
        this.b = new int[n3];
        this.b[n3 - 1] = 16;
        this.i = new BigInt(n3);
    }

    public final int getInputBlockSize() {
        int n2 = this.e.getInputBlockSize();
        if (this.f == 0) {
            return (n2 + 1) / 2;
        }
        return n2;
    }

    public final void setPadBits(int n2) {
        if (n2 > 7) {
            throw new IllegalArgumentException("pads > 7");
        }
        this.k = n2;
    }

    public final int getPadBits() {
        return this.k;
    }

    public final void update(byte[] byArray, int n2, int n3) {
        if (!this.h) {
            throw new IllegalStateException("cipher was not initialized");
        }
        this.g.write(byArray, n2, n3);
        if (this.g.size() > this.getInputBlockSize() + 1) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
    }

    public final byte[] doFinalEncrypt() {
        if (!this.h) {
            throw new IllegalStateException("cipher was not initialized");
        }
        byte[] byArray = this.g.toByteArray();
        this.g.reset();
        int n2 = byArray.length;
        boolean bl = false;
        byte[] byArray2 = byArray;
        RSACipherISO9796Padding rSACipherISO9796Padding = this;
        if (rSACipherISO9796Padding.f == 0) {
            return rSACipherISO9796Padding.a(byArray2, 0, n2);
        }
        return rSACipherISO9796Padding.b(byArray2, 0, n2);
    }

    private byte[] a(byte[] byArray, int n2, int n3) {
        int n4;
        byte[] byArray2 = new byte[(this.j + 7) / 8];
        int n5 = this.k + 1;
        int n6 = (this.j + 13) / 16;
        for (n4 = 0; n4 < n6; n4 += n3) {
            if (n4 > n6 - n3) {
                System.arraycopy(byArray, n2 + n3 - (n6 - n4), byArray2, byArray2.length - n6, n6 - n4);
                continue;
            }
            System.arraycopy(byArray, n2, byArray2, byArray2.length - (n4 + n3), n3);
        }
        for (n4 = byArray2.length - 2 * n6; n4 != byArray2.length; n4 += 2) {
            byte by = byArray2[byArray2.length - n6 + n4 / 2];
            byArray2[n4] = (byte)(c[(by & 0xFF) >>> 4] << 4 | c[by & 0xF]);
            byArray2[n4 + 1] = by;
        }
        int n7 = byArray2.length - 2 * n3;
        byArray2[n7] = (byte)(byArray2[n7] ^ n5);
        byArray2[byArray2.length - 1] = (byte)(byArray2[byArray2.length - 1] << 4 | 6);
        n4 = 8 - (this.j - 1) % 8;
        int n8 = 0;
        if (n4 != 8) {
            byArray2[0] = (byte)(byArray2[0] & 255 >>> n4);
            byArray2[0] = (byte)(byArray2[0] | 128 >>> n4);
        } else {
            byArray2[0] = 0;
            byArray2[1] = (byte)(byArray2[1] | 0x80);
            n8 = 1;
        }
        return this.e.a(byArray2, n8, byArray2.length - n8);
    }

    private byte[] b(byte[] objectArray, int n2, int n3) {
        int n4;
        Object[] objectArray2;
        objectArray = this.e.a((byte[])objectArray, n2, n3);
        n2 = 1;
        int n5 = (this.j + 13) / 16;
        int[] nArray = Utils.fromByteArray(objectArray, n3 / 4);
        objectArray = nArray;
        Object[] objectArray3 = new int[nArray.length];
        this.i.divide((int[])objectArray, this.b, null, this.m);
        if (BigInt.equals(this.m, this.a)) {
            Utils.copy(objectArray, objectArray3);
        } else {
            this.i.subtract(this.l, (int[])objectArray, this.n);
            this.i.divide(this.n, this.b, null, this.m);
            if (BigInt.equals(this.m, this.a)) {
                Utils.copy(this.n, objectArray3);
            } else {
                throw new IllegalStateException("resulting integer iS or (modulus - iS) is not congruent to 6 mod 16");
            }
        }
        objectArray = objectArray3;
        objectArray = Utils.toByteArray(objectArray3, objectArray.length << 2);
        if (objectArray[0] == 0) {
            objectArray3 = new byte[objectArray.length - 1];
            System.arraycopy(objectArray, 1, objectArray3, 0, objectArray3.length);
            objectArray2 = objectArray3;
        } else {
            objectArray2 = objectArray = objectArray;
        }
        if ((objectArray2[objectArray.length - 1] & 0xF) != 6) {
            throw new IllegalStateException("invalid forcing byte in block");
        }
        objectArray[objectArray.length - 1] = (byte)((objectArray[objectArray.length - 1] & 0xFF) >>> 4 | d[(objectArray[objectArray.length - 2] & 0xFF) >> 4] << 4);
        objectArray[0] = (byte)(c[(objectArray[1] & 0xFF) >>> 4] << 4 | c[objectArray[1] & 0xF]);
        boolean bl = false;
        int n6 = 0;
        for (int i2 = objectArray.length - 1; i2 >= objectArray.length - 2 * n5; i2 -= 2) {
            n4 = c[(objectArray[i2] & 0xFF) >>> 4] << 4 | c[objectArray[i2] & 0xF];
            if (((objectArray[i2 - 1] ^ n4) & 0xFF) == 0) continue;
            if (!bl) {
                bl = true;
                n2 = (objectArray[i2 - 1] ^ n4) & 0xFF;
                n6 = i2 - 1;
                continue;
            }
            throw new IllegalStateException("invalid tsums in block");
        }
        objectArray[n6] = 0;
        byte[] byArray = new byte[(objectArray.length - n6) / 2];
        for (n4 = 0; n4 < byArray.length; ++n4) {
            byArray[n4] = objectArray[2 * n4 + n6 + 1];
        }
        this.k = n2 - 1;
        return byArray;
    }
}

