/*
 * Decompiled with CFR 0.152.
 */
package ua.com.dbosoft.autoclient.app.ua_currency_sale;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import ua.com.dbosoft.autoclient.app.account.Iban;
import ua.com.dbosoft.autoclient.app.c;
import ua.com.dbosoft.autoclient.app.validation.a;
import ua.com.dbosoft.autoclient.format.ibank2.d;
import ua.com.dbosoft.autoclient.format.json.BigDecimalSerializer;
import ua.com.dbosoft.autoclient.format.json.LocalDateSerializer;

public class UaCurrencySale
implements c {
    private static final ua.com.dbosoft.autoclient.format.ibank2.c<UaCurrencySale> UA_CURRENCY_SALE_WRITER = new ua.com.dbosoft.autoclient.format.ibank2.c<UaCurrencySale>(UaCurrencySale.class);
    private long id;
    private Integer statusCode;
    @JsonProperty(value="DATE_DOC")
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate date;
    @JsonProperty(value="NUM_DOC")
    private String number;
    @JsonProperty(value="CLN_NAME")
    private String clientName;
    @JsonProperty(value="CLN_ADDR")
    private String clientAddress;
    @JsonProperty(value="CLN_PHONES")
    private String clientPhone;
    @JsonProperty(value="CLN_EMPLOYEE_FIO")
    private String clientEmployeeFullName;
    @JsonProperty(value="CLN_EMPLOYEE_PHONE")
    private String clientEmployeePhone;
    @JsonProperty(value="BNK_NAME")
    private String bankName;
    @JsonProperty(value="BNK_MFO")
    private String bankCode;
    @JsonProperty(value="SALE_SUM")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal saleSum;
    @JsonProperty(value="SALE_CURRENCY")
    private String saleCurrency;
    @JsonProperty(value="SALE_ACCOUNT")
    private String saleAccount;
    @JsonProperty(value="SALE_KIND")
    private String saleKind;
    @JsonProperty(value="SALE_BNK_ACCOUNT")
    private String saleBankAccount;
    @JsonProperty(value="SALE_RATE_KIND")
    private String saleRateKind;
    @JsonProperty(value="SALE_RATE")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal saleRate;
    @JsonProperty(value="PURCHASE_SUM")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal purchaseSum;
    @JsonProperty(value="PURCHASE_ACCOUNT")
    private String purchaseAccount;
    @JsonProperty(value="PURCHASE_BNK_NAME")
    private String purchaseBankName;
    @JsonProperty(value="PURCHASE_BNK_MFO")
    private String purchaseBankCode;
    @JsonProperty(value="COMMISSION")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal commission;
    @JsonProperty(value="RETURN_ACCOUNT")
    private String returnAccount;
    @JsonProperty(value="EXPERIENCE_DATE")
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate experienceDate;
    @JsonProperty(value="CURRENCY_DATE")
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate currencyDate;
    @JsonProperty(value="SALE_PURPOSE")
    private String salePurpose;
    @JsonProperty(value="ATT_CNT")
    private Integer attachmentsCount;
    @JsonProperty(value="FORWARD")
    private Integer forward;
    @JsonProperty(value="FORWARD_CONDITION")
    private String forwardCondition;
    @JsonProperty(value="FORWARD_COVERAGE_AMOUNT")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal forwardCoverageAmount;

    @Override
    @d(a="DATE_DOC", b=0, c=false)
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate localDate) {
        this.date = localDate;
    }

    @Override
    @d(a="NUM_DOC", b=1, c=false)
    @Size(max=10, message="{fieldLength} \"{desc.NUM_DOC}\" {mustBeNotGreater} {max} {symbols5} (NUM_DOC)")
    public @Size(max=10, message="{fieldLength} \"{desc.NUM_DOC}\" {mustBeNotGreater} {max} {symbols5} (NUM_DOC)") String getNumber() {
        return this.number;
    }

    public void setNumber(String string) {
        this.number = string;
    }

    @d(a="CLN_NAME", b=2, c=false)
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String string) {
        this.clientName = string;
    }

    @d(a="CLN_ADDR", b=3, c=false)
    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(String string) {
        this.clientAddress = string;
    }

    @d(a="CLN_PHONES", b=4, c=false)
    public String getClientPhone() {
        return this.clientPhone;
    }

    public void setClientPhone(String string) {
        this.clientPhone = string;
    }

    @d(a="CLN_EMPLOYEE_FIO", b=5, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_EMPLOYEE_FIO}\" (CLN_EMPLOYEE_FIO)", groups={a.class})
    @Size(max=40, message="{fieldLength} \"{desc.CLN_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_FIO)")
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_EMPLOYEE_FIO}\" (CLN_EMPLOYEE_FIO)", groups={a.class}) @Size(max=40, message="{fieldLength} \"{desc.CLN_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_FIO)") String getClientEmployeeFullName() {
        return this.clientEmployeeFullName;
    }

    public void setClientEmployeeFullName(String string) {
        this.clientEmployeeFullName = string;
    }

    @d(a="CLN_EMPLOYEE_PHONE", b=6, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_EMPLOYEE_PHONE}\" (CLN_EMPLOYEE_PHONE)", groups={a.class})
    @Size(max=20, message="{fieldLength} \"{desc.CLN_EMPLOYEE_PHONE}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_PHONE)")
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_EMPLOYEE_PHONE}\" (CLN_EMPLOYEE_PHONE)", groups={a.class}) @Size(max=20, message="{fieldLength} \"{desc.CLN_EMPLOYEE_PHONE}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_PHONE)") String getClientEmployeePhone() {
        return this.clientEmployeePhone;
    }

    public void setClientEmployeePhone(String string) {
        this.clientEmployeePhone = string;
    }

    @d(a="BNK_NAME", b=7, c=false)
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String string) {
        this.bankName = string;
    }

    @d(a="BNK_MFO", b=8, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.BNK_MFO}\" (BNK_MFO)")
    public @NotNull(message="{emptyRequiredField} \"{desc.BNK_MFO}\" (BNK_MFO)") String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String string) {
        this.bankCode = string;
    }

    @d(a="SALE_SUM", b=9, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.SALE_SUM}\" (SALE_SUM)")
    @Digits(integer=10, fraction=0x7FFFFFFF, message="{incorrectAmount} (SALE_SUM)")
    @Positive(message="{sumInFieldMustBePositive} (SALE_SUM)")
    public @NotNull(message="{emptyRequiredField} \"{desc.SALE_SUM}\" (SALE_SUM)") @Digits(integer=10, fraction=0x7FFFFFFF, message="{incorrectAmount} (SALE_SUM)") @Positive(message="{sumInFieldMustBePositive} (SALE_SUM)") BigDecimal getSaleSum() {
        return this.saleSum;
    }

    public void setSaleSum(BigDecimal bigDecimal) {
        this.saleSum = bigDecimal;
    }

    @d(a="SALE_CURRENCY", b=10, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.SALE_CURRENCY}\" (SALE_CURRENCY)")
    @Size(min=3, max=3, message="{fieldLength} \"{desc.SALE_CURRENCY}\" {mustBe} {max} {symbols3} (SALE_CURRENCY)")
    public @NotNull(message="{emptyRequiredField} \"{desc.SALE_CURRENCY}\" (SALE_CURRENCY)") @Size(min=3, max=3, message="{fieldLength} \"{desc.SALE_CURRENCY}\" {mustBe} {max} {symbols3} (SALE_CURRENCY)") String getSaleCurrency() {
        return this.saleCurrency;
    }

    public void setSaleCurrency(String string) {
        this.saleCurrency = string;
    }

    @d(a="SALE_ACCOUNT", b=11, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.SALE_ACCOUNT}\" (SALE_ACCOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.SALE_ACCOUNT}\" (SALE_ACCOUNT)") String getSaleAccount() {
        return this.saleAccount;
    }

    public void setSaleAccount(String string) {
        this.saleAccount = string;
    }

    @d(a="SALE_KIND", b=12, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.SALE_KIND}\" (SALE_KIND)")
    @Pattern(regexp="[01]", message="{fieldFillingError} \"{desc.SALE_KIND}\" (SALE_KIND)")
    public @NotNull(message="{emptyRequiredField} \"{desc.SALE_KIND}\" (SALE_KIND)") @Pattern(regexp="[01]", message="{fieldFillingError} \"{desc.SALE_KIND}\" (SALE_KIND)") String getSaleKind() {
        return this.saleKind;
    }

    public void setSaleKind(String string) {
        this.saleKind = string;
    }

    @d(a="SALE_BNK_ACCOUNT", b=13, c=false)
    @Iban(fieldName="SALE_BNK_ACCOUNT")
    public String getSaleBankAccount() {
        return this.saleBankAccount;
    }

    public void setSaleBankAccount(String string) {
        this.saleBankAccount = string;
    }

    @d(a="SALE_RATE_KIND", b=14, c=false)
    public String getSaleRateKind() {
        return this.saleRateKind;
    }

    public void setSaleRateKind(String string) {
        this.saleRateKind = string;
    }

    @d(a="SALE_RATE", b=15, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.SALE_RATE}\" (SALE_RATE)", groups={a.class})
    @Digits(integer=6, fraction=0x7FFFFFFF, message="{incorrectAmount} (SALE_RATE)")
    @Positive(message="{sumInFieldMustBePositive} (SALE_RATE)")
    public @NotNull(message="{emptyRequiredField} \"{desc.SALE_RATE}\" (SALE_RATE)", groups={a.class}) @Digits(integer=6, fraction=0x7FFFFFFF, message="{incorrectAmount} (SALE_RATE)") @Positive(message="{sumInFieldMustBePositive} (SALE_RATE)") BigDecimal getSaleRate() {
        return this.saleRate;
    }

    public void setSaleRate(BigDecimal bigDecimal) {
        this.saleRate = bigDecimal;
    }

    @d(a="PURCHASE_SUM", b=16, c=false)
    public BigDecimal getPurchaseSum() {
        return this.purchaseSum;
    }

    public void setPurchaseSum(BigDecimal bigDecimal) {
        this.purchaseSum = bigDecimal;
    }

    @d(a="PURCHASE_ACCOUNT", b=17, c=false)
    @Iban(fieldName="PURCHASE_ACCOUNT", groups={a.class})
    public String getPurchaseAccount() {
        return this.purchaseAccount;
    }

    public void setPurchaseAccount(String string) {
        this.purchaseAccount = string;
    }

    @d(a="PURCHASE_BNK_NAME", b=18, c=false)
    public String getPurchaseBankName() {
        return this.purchaseBankName;
    }

    public void setPurchaseBankName(String string) {
        this.purchaseBankName = string;
    }

    @d(a="PURCHASE_BNK_MFO", b=19, c=false)
    public String getPurchaseBankCode() {
        return this.purchaseBankCode;
    }

    public void setPurchaseBankCode(String string) {
        this.purchaseBankCode = string;
    }

    @d(a="COMMISSION", b=20, c=false)
    @Digits(integer=2, fraction=3, message="{incorrectAmount} (COMMISSION)")
    @PositiveOrZero(message="{incorrectAmount} (COMMISSION)")
    public @Digits(integer=2, fraction=3, message="{incorrectAmount} (COMMISSION)") @PositiveOrZero(message="{incorrectAmount} (COMMISSION)") BigDecimal getCommission() {
        return this.commission;
    }

    public void setCommission(BigDecimal bigDecimal) {
        this.commission = bigDecimal;
    }

    @d(a="RETURN_ACCOUNT", b=21, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RETURN_ACCOUNT}\" (RETURN_ACCOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RETURN_ACCOUNT}\" (RETURN_ACCOUNT)") String getReturnAccount() {
        return this.returnAccount;
    }

    public void setReturnAccount(String string) {
        this.returnAccount = string;
    }

    @d(a="EXPERIENCE_DATE", b=22, c=false)
    public LocalDate getExperienceDate() {
        return this.experienceDate;
    }

    public void setExperienceDate(LocalDate localDate) {
        this.experienceDate = localDate;
    }

    @d(a="CURRENCY_DATE", b=23, c=false)
    public LocalDate getCurrencyDate() {
        return this.currencyDate;
    }

    public void setCurrencyDate(LocalDate localDate) {
        this.currencyDate = localDate;
    }

    @d(a="SALE_PURPOSE", b=24)
    public String getSalePurpose() {
        return this.salePurpose;
    }

    public void setSalePurpose(String string) {
        this.salePurpose = string;
    }

    @d(a="ATT_CNT", b=25)
    public Integer getAttachmentsCount() {
        return this.attachmentsCount;
    }

    public void setAttachmentsCount(Integer n2) {
        this.attachmentsCount = n2;
    }

    @d(a="FORWARD", b=26)
    public Integer getForward() {
        return this.forward;
    }

    public void setForward(Integer n2) {
        this.forward = n2;
    }

    @d(a="FORWARD_CONDITION", b=27)
    @NotNull(message="{emptyRequiredField} \"{desc.FORWARD_CONDITION}\" (FORWARD_CONDITION)", groups={a.class})
    @Pattern(regexp="[01]", message="{incorrectForwardCondition} (FORWARD_CONDITION)", groups={a.class})
    public @NotNull(message="{emptyRequiredField} \"{desc.FORWARD_CONDITION}\" (FORWARD_CONDITION)", groups={a.class}) @Pattern(regexp="[01]", message="{incorrectForwardCondition} (FORWARD_CONDITION)", groups={a.class}) String getForwardCondition() {
        return this.forwardCondition;
    }

    public void setForwardCondition(String string) {
        this.forwardCondition = string;
    }

    @d(a="FORWARD_COVERAGE_AMOUNT", b=28)
    @NotNull(message="{emptyRequiredField} \"{desc.FORWARD_COVERAGE_AMOUNT}\" (FORWARD_COVERAGE_AMOUNT)", groups={a.class})
    @Digits(integer=10, fraction=6, message="{incorrectAmount} (FORWARD_COVERAGE_AMOUNT)")
    @Positive(message="{sumInFieldMustBePositive} (FORWARD_COVERAGE_AMOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.FORWARD_COVERAGE_AMOUNT}\" (FORWARD_COVERAGE_AMOUNT)", groups={a.class}) @Digits(integer=10, fraction=6, message="{incorrectAmount} (FORWARD_COVERAGE_AMOUNT)") @Positive(message="{sumInFieldMustBePositive} (FORWARD_COVERAGE_AMOUNT)") BigDecimal getForwardCoverageAmount() {
        return this.forwardCoverageAmount;
    }

    public void setForwardCoverageAmount(BigDecimal bigDecimal) {
        this.forwardCoverageAmount = bigDecimal;
    }

    @Override
    @JsonIgnore
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l2) {
        this.id = l2;
    }

    @Override
    public String toIBank2(boolean bl) {
        return UA_CURRENCY_SALE_WRITER.a(this, bl);
    }

    @Override
    @JsonIgnore
    public String getType() {
        return "ua_currency_sale";
    }

    @Override
    @JsonIgnore
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void setStatusCode(Integer n2) {
        this.statusCode = n2;
    }
}

