/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.log.LogKey;
import com.bifit.security.pkix.log.LogParam;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EncapsulatedContentInfo
extends AbstractASN1Sequence {
    private ASN1ObjectIdentifier a;
    private ASN1OctetString b;
    public static final ASN1Template TEMPLATE = new a();

    public EncapsulatedContentInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(EncapsulatedContentInfo.class);
        this.debug(new LogParam(LogKey.OID, aSN1ObjectIdentifier.toString()).toString());
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = aSN1ObjectIdentifier;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.a;
    }

    public void setContentType(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug(new LogParam(LogKey.OID, aSN1ObjectIdentifier.toString()).toString());
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = aSN1ObjectIdentifier;
    }

    public ASN1OctetString getContent() {
        return this.b;
    }

    public void setContent(ASN1OctetString aSN1OctetString) {
        this.debug(new LogParam(LogKey.CONTENT, aSN1OctetString).toString());
        this.b = aSN1OctetString;
    }

    public void setContent(ASN1Value aSN1Value) {
        this.debug(new LogParam(LogKey.CONTENT, aSN1Value).toString());
        this.b = new ASN1OctetString(aSN1Value.encode());
    }

    public boolean hasContent() {
        return this.b != null;
    }

    public static EncapsulatedContentInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (EncapsulatedContentInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement((ASN1Template)new ASN1ObjectIdentifier.Template());
            this.seqt.addOptionalElement((ASN1Template)new ASN1Explicit.Template(ASN1Tag.get((long)0L), (ASN1Template)new ASN1OctetString.Template()));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws InvalidBERException, IOException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (ASN1ObjectIdentifier)aSN1Tag.elementAt(0);
            aSN1Tag = aSN1Tag.elementAt(1) == null ? null : (ASN1OctetString)((ASN1Explicit)aSN1Tag.elementAt(1)).getContent();
            object = new EncapsulatedContentInfo((ASN1ObjectIdentifier)object);
            ((EncapsulatedContentInfo)object).setContent((ASN1OctetString)aSN1Tag);
            return object;
        }
    }
}

