/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EncryptedContentInfo
extends AbstractASN1Sequence {
    private ASN1ObjectIdentifier a;
    private AlgorithmIdentifier b;
    private ASN1OctetString c;
    public static final ASN1Template TEMPLATE = new a();

    public EncryptedContentInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, AlgorithmIdentifier algorithmIdentifier) {
        super(EncryptedContentInfo.class);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier, algorithmIdentifier);
        this.a = aSN1ObjectIdentifier;
        this.b = algorithmIdentifier;
    }

    public void setContentType(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = aSN1ObjectIdentifier;
    }

    public void setContentEncryptionAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.b = algorithmIdentifier;
    }

    public void setEncryptedContent(ASN1OctetString aSN1OctetString) {
        this.c = aSN1OctetString;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.a;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.b;
    }

    public ASN1OctetString getEncryptedContent() {
        return this.c;
    }

    public static EncryptedContentInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (EncryptedContentInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Template)new ASN1OctetString.Template());
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = new EncryptedContentInfo((ASN1ObjectIdentifier)aSN1Tag.elementAt(0), (AlgorithmIdentifier)aSN1Tag.elementAt(1));
            ((EncryptedContentInfo)object).setEncryptedContent((ASN1OctetString)aSN1Tag.elementAt(2));
            return object;
        }
    }
}

