/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Set;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.CertificateChoices;
import com.bifit.security.pkix.cms.EncryptedContentInfo;
import com.bifit.security.pkix.cms.IssuerAndSerialNumber;
import com.bifit.security.pkix.cms.KeyAgreeRecipientIdentifier;
import com.bifit.security.pkix.cms.KeyAgreeRecipientInfo;
import com.bifit.security.pkix.cms.OriginatorIdentifierOrKey;
import com.bifit.security.pkix.cms.OriginatorInfo;
import com.bifit.security.pkix.cms.RecipientEncryptedKey;
import com.bifit.security.pkix.cms.RecipientEncryptedKeys;
import com.bifit.security.pkix.cms.RecipientInfo;
import com.bifit.security.pkix.cms.SetOfAttribute;
import com.bifit.security.pkix.crypto.CipherAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.AbstractASN1Value;
import com.bifit.security.pkix.primitive.AbstractGenericASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.AttributeCertificateInfo;
import com.bifit.security.pkix.x509.Certificate;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.ext.KeyUsage;
import com.bifit.security.pkix.x509.ext.SubjectKeyIdentifier;
import com.bifit.security.pkix.x509.ext.UsageBits;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class EnvelopedData
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final OriginatorInfo b;
    private final ASN1Set c;
    private final EncryptedContentInfo d;
    private final SetOfAttribute e;
    public static final ASN1Template TEMPLATE = new a();

    public EnvelopedData(ASN1Integer aSN1Integer, OriginatorInfo originatorInfo, ASN1Set aSN1Set, EncryptedContentInfo encryptedContentInfo, SetOfAttribute setOfAttribute) {
        super(EnvelopedData.class);
        PKIXUtils.verifyNotNull(aSN1Integer, aSN1Set, encryptedContentInfo);
        this.a = aSN1Integer;
        this.b = originatorInfo;
        this.c = aSN1Set;
        this.d = encryptedContentInfo;
        this.e = setOfAttribute;
    }

    public static EnvelopedData getInstance(byte[] byArray) throws PKIXException {
        try {
            return (EnvelopedData)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.b;
    }

    public ASN1Set getRecipientInfos() {
        return this.c;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.d;
    }

    public SetOfAttribute getUnprotectedAttrs() {
        return this.e;
    }

    public boolean hasIssuerCertificate() {
        return this.b != null && this.b.getCerts().size() > 0;
    }

    public List<Certificate> getIssuerCertificates() {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        if (this.b != null && this.b.getCerts() != null) {
            for (int i = 0; i < this.b.getCerts().size(); ++i) {
                arrayList.add(this.b.getCert(i).getCertificate());
            }
        }
        return arrayList;
    }

    private ASN1BitString a(OriginatorIdentifierOrKey object, List<Certificate> iterator) throws PKIXException {
        if (((OriginatorIdentifierOrKey)object).isOriginatorPublicKey()) {
            return ((OriginatorIdentifierOrKey)object).getOriginatorPublicKey().getPublicKey();
        }
        if (((OriginatorIdentifierOrKey)object).isIssuerAndSerialNumber()) {
            object = ((OriginatorIdentifierOrKey)object).getIssuerAndSerialNumber();
            Object object2 = this.getIssuerCertificates();
            object2.addAll(iterator);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (object2 == null || !((AbstractASN1Value)object).equals(new IssuerAndSerialNumber((Certificate)object2))) continue;
                return ((Certificate)object2).getInfo().getSubjectPublicKeyInfo().getSubjectPublicKey();
            }
        } else if (((OriginatorIdentifierOrKey)object).isSubjectKeyIdentifier()) {
            object = ((OriginatorIdentifierOrKey)object).getSubjectKeyIdentifier().toByteArray();
            Object object3 = this.getIssuerCertificates();
            object3.addAll(iterator);
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                byte[] byArray;
                object3 = iterator.next();
                if (object3 == null) continue;
                try {
                    byArray = new SubjectKeyIdentifier(((Certificate)object3).getInfo().getExtension(SubjectKeyIdentifier.OID)).getKeyIdentifierBytes();
                }
                catch (InvalidBERException invalidBERException) {
                    throw new PKIXException(invalidBERException.getMessage());
                }
                if (!Arrays.equals((byte[])object, byArray)) continue;
                return ((Certificate)object3).getInfo().getSubjectPublicKeyInfo().getSubjectPublicKey();
            }
        } else {
            throw new PKIXException("Invalid originator");
        }
        throw new PKIXException("Issuer certificate needed");
    }

    public ASN1BitString getIssuerPublicKey(Certificate certificate, List<Certificate> list) throws PKIXException {
        for (int i = 0; i < this.c.size(); ++i) {
            KeyAgreeRecipientInfo keyAgreeRecipientInfo = ((RecipientInfo)this.c.elementAt(i)).getKeyAgree();
            RecipientEncryptedKeys recipientEncryptedKeys = keyAgreeRecipientInfo.getRecipientEncryptedKeys();
            for (int j = 0; j < recipientEncryptedKeys.size(); ++j) {
                Object object;
                Object object2 = (RecipientEncryptedKey)recipientEncryptedKeys.elementAt(j);
                if (((KeyAgreeRecipientIdentifier)(object2 = ((RecipientEncryptedKey)object2).getRid())).isIssuerAndSerialNumber()) {
                    object2 = new IssuerAndSerialNumber(certificate);
                    object = ((KeyAgreeRecipientIdentifier)object2).getIssuerAndSerialNumber();
                    if (!((AbstractASN1Value)object2).equals(object)) continue;
                    return this.a(keyAgreeRecipientInfo.getOriginator(), list);
                }
                if (((KeyAgreeRecipientIdentifier)object2).isRKeyId()) {
                    try {
                        object = new SubjectKeyIdentifier(certificate.getInfo().getExtension(SubjectKeyIdentifier.OID)).getKeyIdentifierBytes();
                    }
                    catch (InvalidBERException invalidBERException) {
                        throw new PKIXException(invalidBERException.getMessage());
                    }
                    object2 = ((KeyAgreeRecipientIdentifier)object2).getRKeyId().getSubjectKeyIdentifier().toByteArray();
                    if (!Arrays.equals((byte[])object, (byte[])object2)) continue;
                    return this.a(keyAgreeRecipientInfo.getOriginator(), list);
                }
                throw new PKIXException("Unknown type of KeyAgreeRecipientIdentifier");
            }
        }
        throw new PKIXException("IssuerPublicKey does not found.");
    }

    public Certificate getIssuerCertificate(Certificate certificate, List<Certificate> list) throws PKIXException {
        for (int i = 0; i < this.c.size(); ++i) {
            KeyAgreeRecipientInfo keyAgreeRecipientInfo = ((RecipientInfo)this.c.elementAt(i)).getKeyAgree();
            RecipientEncryptedKeys recipientEncryptedKeys = keyAgreeRecipientInfo.getRecipientEncryptedKeys();
            for (int j = 0; j < recipientEncryptedKeys.size(); ++j) {
                Object object;
                Object object2 = (RecipientEncryptedKey)recipientEncryptedKeys.elementAt(j);
                if (((KeyAgreeRecipientIdentifier)(object2 = ((RecipientEncryptedKey)object2).getRid())).isIssuerAndSerialNumber()) {
                    object2 = new IssuerAndSerialNumber(certificate);
                    object = ((KeyAgreeRecipientIdentifier)object2).getIssuerAndSerialNumber();
                    if (!((AbstractASN1Value)object2).equals(object)) continue;
                    return this.b(keyAgreeRecipientInfo.getOriginator(), list);
                }
                if (((KeyAgreeRecipientIdentifier)object2).isRKeyId()) {
                    try {
                        object = new SubjectKeyIdentifier(certificate.getInfo().getExtension(SubjectKeyIdentifier.OID)).getKeyIdentifierBytes();
                        object2 = ((KeyAgreeRecipientIdentifier)object2).getRKeyId().getSubjectKeyIdentifier().toByteArray();
                        if (!Arrays.equals((byte[])object, (byte[])object2)) continue;
                        return this.b(keyAgreeRecipientInfo.getOriginator(), list);
                    }
                    catch (InvalidBERException invalidBERException) {
                        throw new PKIXException(invalidBERException.getMessage());
                    }
                }
                throw new PKIXException("Unknown type of KeyAgreeRecipientIdentifier");
            }
        }
        throw new PKIXException("Issuer certificate does not found.");
    }

    private Certificate b(OriginatorIdentifierOrKey object, List<Certificate> iterator) throws PKIXException {
        Object object2 = this.getIssuerCertificates();
        object2.addAll(iterator);
        if (((OriginatorIdentifierOrKey)object).isOriginatorPublicKey()) {
            return null;
        }
        if (((OriginatorIdentifierOrKey)object).isIssuerAndSerialNumber()) {
            object = ((OriginatorIdentifierOrKey)object).getIssuerAndSerialNumber();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (object2 == null || !((AbstractASN1Value)object).equals(new IssuerAndSerialNumber((Certificate)object2))) continue;
                return object2;
            }
        } else if (((OriginatorIdentifierOrKey)object).isSubjectKeyIdentifier()) {
            object = ((OriginatorIdentifierOrKey)object).getSubjectKeyIdentifier().toByteArray();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (object2 == null) continue;
                try {
                    byte[] byArray = new SubjectKeyIdentifier(((Certificate)object2).getInfo().getExtension(SubjectKeyIdentifier.OID)).getKeyIdentifierBytes();
                    if (!Arrays.equals((byte[])object, byArray)) continue;
                    return object2;
                }
                catch (InvalidBERException invalidBERException) {
                    throw new PKIXException(invalidBERException.getMessage());
                }
            }
        } else {
            throw new PKIXException("Invalid originator");
        }
        throw new PKIXException("Issuer certificate needed");
    }

    public byte[] getRndBytes(Certificate certificate) throws PKIXException {
        for (int i = 0; i < this.c.size(); ++i) {
            KeyAgreeRecipientInfo keyAgreeRecipientInfo = ((RecipientInfo)this.c.elementAt(i)).getKeyAgree();
            RecipientEncryptedKeys recipientEncryptedKeys = keyAgreeRecipientInfo.getRecipientEncryptedKeys();
            for (int j = 0; j < recipientEncryptedKeys.size(); ++j) {
                Object object;
                Object object2 = (RecipientEncryptedKey)recipientEncryptedKeys.elementAt(j);
                if (((KeyAgreeRecipientIdentifier)(object2 = ((RecipientEncryptedKey)object2).getRid())).isIssuerAndSerialNumber()) {
                    object2 = new IssuerAndSerialNumber(certificate);
                    object = ((KeyAgreeRecipientIdentifier)object2).getIssuerAndSerialNumber();
                    if (!((AbstractASN1Value)object2).equals(object)) continue;
                    return keyAgreeRecipientInfo.getUkm().toByteArray();
                }
                if (((KeyAgreeRecipientIdentifier)object2).isRKeyId()) {
                    try {
                        object = new SubjectKeyIdentifier(certificate.getInfo().getExtension(SubjectKeyIdentifier.OID)).getKeyIdentifierBytes();
                    }
                    catch (InvalidBERException invalidBERException) {
                        throw new PKIXException(invalidBERException.getMessage());
                    }
                    object2 = ((KeyAgreeRecipientIdentifier)object2).getRKeyId().getSubjectKeyIdentifier().toByteArray();
                    if (!Arrays.equals((byte[])object, (byte[])object2)) continue;
                    return keyAgreeRecipientInfo.getUkm().toByteArray();
                }
                throw new PKIXException("Unknown type of KeyAgreeRecipientIdentifier");
            }
        }
        return null;
    }

    public byte[] getEnctyptedSessionKey(Certificate certificate) throws PKIXException, InvalidBERException {
        for (int i = 0; i < this.c.size(); ++i) {
            AbstractASN1Value abstractASN1Value = ((RecipientInfo)this.c.elementAt(i)).getKeyAgree();
            abstractASN1Value = ((KeyAgreeRecipientInfo)abstractASN1Value).getRecipientEncryptedKeys();
            for (int j = 0; j < ((AbstractGenericASN1Sequence)abstractASN1Value).size(); ++j) {
                Object object;
                RecipientEncryptedKey recipientEncryptedKey = (RecipientEncryptedKey)((AbstractGenericASN1Sequence)abstractASN1Value).elementAt(j);
                Object object2 = recipientEncryptedKey.getRid();
                if (((KeyAgreeRecipientIdentifier)object2).isIssuerAndSerialNumber()) {
                    object2 = new IssuerAndSerialNumber(certificate);
                    object = ((KeyAgreeRecipientIdentifier)object2).getIssuerAndSerialNumber();
                    if (!((AbstractASN1Value)object2).equals(object)) continue;
                    return recipientEncryptedKey.getEncryptedKey().toByteArray();
                }
                if (((KeyAgreeRecipientIdentifier)object2).isRKeyId()) {
                    object = new SubjectKeyIdentifier(certificate.getInfo().getExtension(SubjectKeyIdentifier.OID)).getKeyIdentifierBytes();
                    if (!Arrays.equals((byte[])object, (byte[])(object2 = (Object)((KeyAgreeRecipientIdentifier)object2).getRKeyId().getSubjectKeyIdentifier().toByteArray()))) continue;
                    return recipientEncryptedKey.getEncryptedKey().toByteArray();
                }
                throw new PKIXException("Unknown type of KeyAgreeRecipientIdentifier");
            }
        }
        throw new PKIXException("EnctyptedSessionKey does not found.");
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.d.getContentEncryptionAlgorithm();
    }

    public byte[] decryptData(CipherAdapter cipherAdapter) throws CryptoException {
        byte[] byArray = this.d.getEncryptedContent().toByteArray();
        return cipherAdapter.decrypt(byArray);
    }

    public byte[] decryptData(CipherAdapter cipherAdapter, Date date, List<Certificate> list) throws PKIXException {
        int n;
        if (date == null) {
            date = new Date();
        }
        ArrayList<Date> arrayList = new ArrayList<Date>();
        if (this.b != null && this.b.getCerts() != null) {
            for (n = 0; n < this.b.getCerts().size(); ++n) {
                CertificateChoices certificateChoices = this.b.getCert(n);
                if (certificateChoices.isCertificate()) {
                    EnvelopedData.checkKeyUsage(certificateChoices.getCertificate());
                    arrayList.add(certificateChoices.getCertificate().getNotAfter());
                    continue;
                }
                if (certificateChoices.isV2AttrCert()) {
                    AttributeCertificateInfo attributeCertificateInfo = certificateChoices.getV2AttrCert().getAcinfo();
                    Object object = attributeCertificateInfo;
                    object = attributeCertificateInfo.getExtensions();
                    if (object == null) {
                        throw new PKIXException("Certificate info extensions not specified");
                    }
                    if ((object = ((Extensions)object).getExtension(KeyUsage.OID)) == null) {
                        throw new PKIXException("Certificate info key usage not specified");
                    }
                    try {
                        object = ASN1BitString.getInstance((byte[])((Extension)object).getExtnValue().toByteArray());
                        boolean[] blArray = object.toBooleanArray();
                        object = blArray;
                        if (blArray.length < 4 | object[UsageBits.KEY_AGREEMENT.getIndex()] == false) {
                            throw new PKIXException("Illegal certificate key usage");
                        }
                    }
                    catch (InvalidBERException invalidBERException) {
                        throw new PKIXException("Error decoding key usage bits");
                    }
                    arrayList.add(attributeCertificateInfo.getAttrCertValidityPeriod().getNotAfterTime().toDate());
                    continue;
                }
                throw new PKIXException("Unsupported CertificateChoices value");
            }
        }
        for (n = 0; n < this.c.size(); ++n) {
            Object object;
            OriginatorIdentifierOrKey originatorIdentifierOrKey = ((RecipientInfo)this.c.elementAt(n)).getKeyAgree().getOriginator();
            if (originatorIdentifierOrKey.isIssuerAndSerialNumber()) {
                IssuerAndSerialNumber issuerAndSerialNumber = originatorIdentifierOrKey.getIssuerAndSerialNumber();
                for (Certificate certificate : list) {
                    object = new IssuerAndSerialNumber(certificate);
                    if (!((AbstractASN1Value)object).equals(issuerAndSerialNumber)) continue;
                    EnvelopedData.checkKeyUsage(certificate);
                    arrayList.add(certificate.getNotAfter());
                }
                continue;
            }
            if (originatorIdentifierOrKey.isSubjectKeyIdentifier()) {
                byte[] byArray = originatorIdentifierOrKey.getSubjectKeyIdentifier().toByteArray();
                for (Certificate certificate : list) {
                    try {
                        object = new SubjectKeyIdentifier(certificate.getInfo().getExtension(SubjectKeyIdentifier.OID)).getKeyIdentifierBytes();
                    }
                    catch (InvalidBERException invalidBERException) {
                        throw new PKIXException(invalidBERException.getMessage());
                    }
                    if (!Arrays.equals((byte[])object, byArray)) continue;
                    EnvelopedData.checkKeyUsage(certificate);
                    arrayList.add(certificate.getNotAfter());
                }
                continue;
            }
            if (originatorIdentifierOrKey.isOriginatorPublicKey()) continue;
            throw new PKIXException("Unsupported OriginatorIdentifierOrKey type");
        }
        for (Date date2 : arrayList) {
            if (date.compareTo(date2) <= 0) continue;
            throw new PKIXException("Issuer certificate is out of date");
        }
        Object object5 = this.d.getEncryptedContent().toByteArray();
        return cipherAdapter.decrypt((byte[])object5);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.e);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static void checkKeyUsage(Certificate object) throws PKIXException {
        boolean[] blArray = ((Certificate)object).getKeyUsage();
        object = blArray;
        if (blArray != null) {
            if (((Object)object).length < 4 | object[UsageBits.KEY_AGREEMENT.getIndex()] == false) {
                throw new PKIXException("Illegal certificate key usage");
            }
        } else {
            throw new PKIXException("Certificate key usage not specified");
        }
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)0L), OriginatorInfo.TEMPLATE);
            this.seqt.addElement((ASN1Template)ASN1Set.getSetTemplate((ASN1Template)RecipientInfo.TEMPLATE));
            this.seqt.addElement(EncryptedContentInfo.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)1L), SetOfAttribute.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            Assert.debugAssert(((aSN1Tag = this.getSequence(aSN1Tag, inputStream)).size() == 5 ? 1 : 0) != 0);
            return new EnvelopedData((ASN1Integer)aSN1Tag.elementAt(0), (OriginatorInfo)aSN1Tag.elementAt(1), (ASN1Set)aSN1Tag.elementAt(2), (EncryptedContentInfo)aSN1Tag.elementAt(3), (SetOfAttribute)aSN1Tag.elementAt(4));
        }
    }
}

