/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.IssuerAndSerialNumber;
import com.bifit.security.pkix.cms.OriginatorPublicKey;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;

public class OriginatorIdentifierOrKey
extends AbstractASN1Choice {
    private final Type a;
    public static final ASN1Template TEMPLATE = new a();

    OriginatorIdentifierOrKey(Type type, ASN1Value aSN1Value) {
        super(OriginatorIdentifierOrKey.class, aSN1Value);
        this.a = type;
    }

    public static OriginatorIdentifierOrKey getInstanceIssuerAndSerialNum(IssuerAndSerialNumber issuerAndSerialNumber) {
        return new OriginatorIdentifierOrKey(Type.ISSUER_AND_SERIAL_NUMBER, (ASN1Value)issuerAndSerialNumber);
    }

    public static OriginatorIdentifierOrKey getInstanceSubjectKeyIdentifier(ASN1OctetString aSN1OctetString) {
        return new OriginatorIdentifierOrKey(Type.SUBJECT_KEY_IDENTIFIER, (ASN1Value)aSN1OctetString);
    }

    public static OriginatorIdentifierOrKey getInstanceOriginatorPublicKey(OriginatorPublicKey originatorPublicKey) {
        return new OriginatorIdentifierOrKey(Type.ORIGINATOR_PUBLIC_KEY, (ASN1Value)originatorPublicKey);
    }

    public static OriginatorIdentifierOrKey getInstance(byte[] byArray) throws PKIXException {
        try {
            return (OriginatorIdentifierOrKey)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (this.a == Type.ISSUER_AND_SERIAL_NUMBER) {
            return (IssuerAndSerialNumber)this.value;
        }
        return null;
    }

    public ASN1OctetString getSubjectKeyIdentifier() {
        if (this.a == Type.SUBJECT_KEY_IDENTIFIER) {
            return (ASN1OctetString)this.value;
        }
        return null;
    }

    public OriginatorPublicKey getOriginatorPublicKey() {
        if (this.a == Type.ORIGINATOR_PUBLIC_KEY) {
            return (OriginatorPublicKey)this.value;
        }
        return null;
    }

    public Type getType() {
        return this.a;
    }

    @Override
    public ASN1Tag getTag() {
        switch (this.a) {
            case ISSUER_AND_SERIAL_NUMBER: {
                return IssuerAndSerialNumber.TAG;
            }
            case ORIGINATOR_PUBLIC_KEY: {
                return ASN1Tag.get((long)1L);
            }
        }
        Assert.debugAssert((this.a == Type.SUBJECT_KEY_IDENTIFIER ? 1 : 0) != 0);
        return ASN1Tag.get((long)0L);
    }

    public boolean isIssuerAndSerialNumber() {
        return this.a == Type.ISSUER_AND_SERIAL_NUMBER;
    }

    public boolean isSubjectKeyIdentifier() {
        return this.a == Type.SUBJECT_KEY_IDENTIFIER;
    }

    public boolean isOriginatorPublicKey() {
        return this.a == Type.ORIGINATOR_PUBLIC_KEY;
    }

    static /* synthetic */ Type a(ASN1Tag aSN1Tag) {
        switch ((int)aSN1Tag.getNum()) {
            case 0: {
                return Type.SUBJECT_KEY_IDENTIFIER;
            }
            case 1: {
                return Type.ORIGINATOR_PUBLIC_KEY;
            }
        }
        return Type.ISSUER_AND_SERIAL_NUMBER;
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(IssuerAndSerialNumber.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)0L), ASN1OctetString.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)1L), OriginatorPublicKey.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            inputStream = (ASN1Choice)this.choicet.decode(inputStream);
            Type type = OriginatorIdentifierOrKey.a(inputStream.getTag());
            inputStream = inputStream.getValue();
            return new OriginatorIdentifierOrKey(type, (ASN1Value)inputStream);
        }
    }

    public static enum Type {
        ISSUER_AND_SERIAL_NUMBER,
        SUBJECT_KEY_IDENTIFIER,
        ORIGINATOR_PUBLIC_KEY;

    }
}

