/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.KeyAgreeRecipientIdentifier;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RecipientEncryptedKey
extends AbstractASN1Sequence {
    private KeyAgreeRecipientIdentifier a;
    private ASN1OctetString b;
    public static final ASN1Template TEMPLATE = new a();

    public RecipientEncryptedKey(KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier, ASN1OctetString aSN1OctetString) {
        super(RecipientEncryptedKey.class);
        PKIXUtils.verifyNotNull(keyAgreeRecipientIdentifier, aSN1OctetString);
        this.a = keyAgreeRecipientIdentifier;
        this.b = aSN1OctetString;
    }

    public void setRid(KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier) {
        this.a = keyAgreeRecipientIdentifier;
    }

    public void setEncryptedKey(ASN1OctetString aSN1OctetString) {
        this.b = aSN1OctetString;
    }

    public KeyAgreeRecipientIdentifier getRid() {
        return this.a;
    }

    public ASN1OctetString getEncryptedKey() {
        return this.b;
    }

    public static RecipientEncryptedKey getInstance(byte[] byArray) throws PKIXException {
        try {
            return (RecipientEncryptedKey)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(KeyAgreeRecipientIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            Assert.debugAssert(((aSN1Tag = this.getSequence(aSN1Tag, inputStream)).size() == 2 ? 1 : 0) != 0);
            return new RecipientEncryptedKey((KeyAgreeRecipientIdentifier)aSN1Tag.elementAt(0), (ASN1OctetString)aSN1Tag.elementAt(1));
        }
    }
}

