/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1GeneralizedTime;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.OtherKeyAttribute;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RecipientKeyIdentifier
extends AbstractASN1Sequence {
    private ASN1OctetString a;
    private ASN1GeneralizedTime b;
    private OtherKeyAttribute c;
    public static final ASN1Template TEMPLATE = new a();

    public RecipientKeyIdentifier(ASN1OctetString aSN1OctetString) {
        super(RecipientKeyIdentifier.class);
        PKIXUtils.verifyNotNull(aSN1OctetString);
        this.a = aSN1OctetString;
    }

    public static RecipientKeyIdentifier getInstance(byte[] byArray) throws PKIXException {
        try {
            return (RecipientKeyIdentifier)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public void setSubjectKeyIdentifier(ASN1OctetString aSN1OctetString) {
        this.a = aSN1OctetString;
    }

    public void setDate(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.b = aSN1GeneralizedTime;
    }

    public void setOther(OtherKeyAttribute otherKeyAttribute) {
        this.c = otherKeyAttribute;
    }

    public ASN1OctetString getSubjectKeyIdentifier() {
        return this.a;
    }

    public ASN1GeneralizedTime getDate() {
        return this.b;
    }

    public OtherKeyAttribute getOther() {
        return this.c;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
            this.seqt.addOptionalElement(ASN1GeneralizedTime.TEMPLATE);
            this.seqt.addOptionalElement(OtherKeyAttribute.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = new RecipientKeyIdentifier((ASN1OctetString)aSN1Tag.elementAt(0));
            ((RecipientKeyIdentifier)object).setDate((ASN1GeneralizedTime)aSN1Tag.elementAt(1));
            ((RecipientKeyIdentifier)object).setOther((OtherKeyAttribute)aSN1Tag.elementAt(2));
            return object;
        }
    }
}

