/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.IssuerAndSerialNumber;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SignerIdentifier
extends AbstractASN1Choice {
    private final Type a;
    public static final ASN1Template TEMPLATE = new a();

    private SignerIdentifier(Type type, ASN1Value aSN1Value) {
        super(SignerIdentifier.class, aSN1Value);
        this.a = type;
    }

    public static SignerIdentifier getInstance(byte[] byArray) throws PKIXException {
        try {
            return (SignerIdentifier)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public static SignerIdentifier getInstanceIssuerAndSerialNumber(IssuerAndSerialNumber issuerAndSerialNumber) {
        return new SignerIdentifier(Type.ISSUER_AND_SERIALNUMBER, (ASN1Value)issuerAndSerialNumber);
    }

    public static SignerIdentifier getInstanceSubjectKeyIdentifier(ASN1OctetString aSN1OctetString) {
        return new SignerIdentifier(Type.SUBJECT_KEY_IDENTIFIER, (ASN1Value)aSN1OctetString);
    }

    public final Type getType() {
        return this.a;
    }

    public final IssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (this.a == Type.ISSUER_AND_SERIALNUMBER) {
            return (IssuerAndSerialNumber)this.value;
        }
        return null;
    }

    public final ASN1OctetString getSubjectKeyIdentifier() {
        if (this.a == Type.SUBJECT_KEY_IDENTIFIER) {
            return (ASN1OctetString)this.value;
        }
        return null;
    }

    @Override
    public final ASN1Tag getTag() {
        ASN1Tag aSN1Tag;
        if (this.a == Type.SUBJECT_KEY_IDENTIFIER) {
            aSN1Tag = ASN1Tag.get((long)0L);
        } else {
            Assert.debugAssert((this.a == Type.ISSUER_AND_SERIALNUMBER ? 1 : 0) != 0);
            aSN1Tag = IssuerAndSerialNumber.TAG;
        }
        return aSN1Tag;
    }

    @Override
    public final void encode(OutputStream outputStream) throws IOException {
        if (this.a == Type.SUBJECT_KEY_IDENTIFIER) {
            this.value.encode(ASN1Tag.get((long)0L), outputStream);
            return;
        }
        Assert.debugAssert((this.a == Type.ISSUER_AND_SERIALNUMBER ? 1 : 0) != 0);
        this.value.encode(outputStream);
    }

    @Override
    public final void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.encode(outputStream);
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(ASN1Tag.get((long)0L), ASN1OctetString.TEMPLATE);
            this.choicet.addElement(IssuerAndSerialNumber.TEMPLATE);
        }

        public final ASN1Value decode(InputStream object) throws InvalidBERException, IOException {
            if ((object = (ASN1Choice)this.choicet.decode((InputStream)object)).getTag() == ASN1Sequence.TAG) {
                object = SignerIdentifier.getInstanceIssuerAndSerialNumber((IssuerAndSerialNumber)object.getValue());
            } else {
                Assert.debugAssert((boolean)object.getTag().equals((Object)ASN1Tag.get((long)0L)));
                object = (ASN1OctetString)object.getValue();
                object = SignerIdentifier.getInstanceSubjectKeyIdentifier((ASN1OctetString)object);
            }
            return object;
        }
    }

    public static enum Type {
        ISSUER_AND_SERIALNUMBER,
        SUBJECT_KEY_IDENTIFIER;

    }
}

