/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.ESSCertIDv2;
import com.bifit.security.pkix.cms.OidCms;
import com.bifit.security.pkix.cms.SetOfAttribute;
import com.bifit.security.pkix.cms.SignerIdentifier;
import com.bifit.security.pkix.cms.SigningCertificateV2;
import com.bifit.security.pkix.crypto.CryptoConverter;
import com.bifit.security.pkix.crypto.DigestAdapter;
import com.bifit.security.pkix.crypto.VerifyAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.Attribute;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Certificate;
import com.bifit.security.pkix.x509.ext.UsageBits;
import com.bifit.security.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class SignerInfo
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final SignerIdentifier b;
    private final AlgorithmIdentifier c;
    private final SetOfAttribute d;
    private final AlgorithmIdentifier e;
    private final ASN1OctetString f;
    private SetOfAttribute g;
    public static final ASN1Template TEMPLATE = new a();

    public SignerInfo(ASN1Integer aSN1Integer, SignerIdentifier signerIdentifier, AlgorithmIdentifier algorithmIdentifier, SetOfAttribute setOfAttribute, AlgorithmIdentifier algorithmIdentifier2, ASN1OctetString aSN1OctetString, SetOfAttribute setOfAttribute2) {
        super(SignerInfo.class);
        PKIXUtils.verifyNotNull(aSN1Integer, signerIdentifier, algorithmIdentifier, algorithmIdentifier2, aSN1OctetString);
        this.a = aSN1Integer;
        this.b = signerIdentifier;
        this.c = algorithmIdentifier;
        this.e = algorithmIdentifier2;
        this.f = aSN1OctetString;
        this.d = setOfAttribute;
        this.g = setOfAttribute2;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public SignerIdentifier getSignerIdentifier() {
        return this.b;
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifer() {
        return this.c;
    }

    public SetOfAttribute getSignedAttributes() {
        return this.d;
    }

    public Attribute getSignedAttribute(int n) {
        Attribute attribute = null;
        if (this.d != null) {
            attribute = this.d.getAttribute(n);
        }
        return attribute;
    }

    public Attribute getSignedAttributeByOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.d.getAttributeByOid(aSN1ObjectIdentifier);
    }

    public boolean hasSignedAttributes() {
        return this.d != null;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.e;
    }

    public ASN1OctetString getSignature() {
        return this.f;
    }

    public SetOfAttribute getUnsignedAttributes() {
        return this.g;
    }

    public void addUnsignedAttribute(Attribute attribute) {
        if (this.g == null) {
            this.g = new SetOfAttribute(attribute);
            return;
        }
        this.g.addAttribute(attribute);
    }

    public Attribute getUnsignedAttribute(int n) {
        Attribute attribute = null;
        if (this.g != null) {
            attribute = this.g.getAttribute(n);
        }
        return attribute;
    }

    public boolean hasUnsignedAttributes() {
        return this.g != null;
    }

    public boolean verify(DigestAdapter object, VerifyAdapter verifyAdapter, byte[] byArray) throws PKIXException, CryptoException {
        ASN1Integer aSN1Integer = this.b.getIssuerAndSerialNumber().getSerialNumber();
        Certificate certificate = verifyAdapter.getCertificate();
        if (byArray == null) {
            throw new PKIXException("Data not found");
        }
        if (certificate.getInfo().getSerialNumber().equals((Object)aSN1Integer)) {
            object = object.digest(byArray);
            return this.a(verifyAdapter, (byte[])object);
        }
        throw new PKIXException("User certificate not found");
    }

    public boolean verify(DigestAdapter object, VerifyAdapter verifyAdapter, InputStream inputStream) throws PKIXException, CryptoException {
        ASN1Integer aSN1Integer = this.b.getIssuerAndSerialNumber().getSerialNumber();
        Certificate certificate = verifyAdapter.getCertificate();
        if (inputStream == null) {
            throw new PKIXException("Data not found");
        }
        if (certificate.getInfo().getSerialNumber().equals((Object)aSN1Integer)) {
            object = object.digest(inputStream);
            return this.a(verifyAdapter, (byte[])object);
        }
        throw new PKIXException("User certificate not found");
    }

    private boolean a(VerifyAdapter verifyAdapter, byte[] object) throws PKIXException, CryptoException {
        if (verifyAdapter == null) {
            throw new PKIXException("VerifyAdapter not found");
        }
        SignerInfo.checkKeyUsage(verifyAdapter.getCertificate());
        ASN1Any aSN1Any = (ASN1Any)this.getSignedAttributeByOid(OidCms.MESSAGE_DIGEST).getValues().elementAt(0);
        try {
            aSN1Any = (ASN1OctetString)aSN1Any.decodeWith(ASN1OctetString.TEMPLATE);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException("Digest format.");
        }
        if (!Arrays.equals(aSN1Any.toByteArray(), (byte[])object)) {
            throw new PKIXException("Incorrect digest of data. " + PKIXUtils.arrayToString(aSN1Any.toByteArray()) + " --- " + PKIXUtils.arrayToString((byte[])object));
        }
        object = new ByteArrayOutputStream();
        try {
            this.d.berEncode(this.d.getTag(), (OutputStream)object);
        }
        catch (IOException iOException) {
            throw new PKIXException("Bad signed attributes.", (Throwable)iOException);
        }
        return verifyAdapter.verify(((ByteArrayOutputStream)object).toByteArray(), CryptoConverter.signOctetString2Bytes(verifyAdapter.getSignatureAlgorithm(), this.f));
    }

    public boolean verifySigningCertificateV2(DigestAdapter object, Certificate certificate) throws PKIXException {
        PKIXUtils.verifyNotNull(object, certificate);
        AbstractASN1Sequence abstractASN1Sequence = this.getSignedAttributeByOid(OidCms.AA_SIGNING_CERTIFICATE_V2);
        abstractASN1Sequence = (ASN1Any)((Attribute)abstractASN1Sequence).getValues().elementAt(0);
        try {
            abstractASN1Sequence = (SigningCertificateV2)abstractASN1Sequence.decodeWith(SigningCertificateV2.TEMPLATE);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException("Digest format.");
        }
        abstractASN1Sequence = ((SigningCertificateV2)abstractASN1Sequence).getESSCertIDv2(certificate);
        if (abstractASN1Sequence == null) {
            return false;
        }
        if (!((ESSCertIDv2)abstractASN1Sequence).getHashAlgorithm().equals(object.getDigestAlgorithm())) {
            return false;
        }
        object = object.digest(certificate.encode());
        if (!Arrays.equals(((ESSCertIDv2)abstractASN1Sequence).getCertHash().toByteArray(), (byte[])object)) {
            throw new PKIXException("Incorrect SigningCertificateV2. " + PKIXUtils.arrayToString(((ESSCertIDv2)abstractASN1Sequence).getCertHash().toByteArray()) + " --- " + PKIXUtils.arrayToString((byte[])object));
        }
        return true;
    }

    public int getSignFormat() {
        if (this.d == null || this.d.getAttributeByOid(OidCms.CONTENT_TYPE) == null || this.d.getAttributeByOid(OidCms.AA_SIGNING_CERTIFICATE_V2) == null || this.d.getAttributeByOid(OidCms.MESSAGE_DIGEST) == null) {
            return 0;
        }
        int n = 1;
        if (this.d.getAttributeByOid(OidCms.AA_ETS_SIG_POLICY_ID) != null) {
            n = 3;
        }
        if (this.g != null && this.g.getAttributeByOid(OidCms.AA_SIGNATURE_TIME_STAMP_TOKEN) != null && this.g.getAttributeByOid(OidCms.AA_ETS_CERTIFICATE_REFS) != null && this.g.getAttributeByOid(OidCms.AA_ETS_REVOCATION_REFS) != null) {
            n |= 4;
        }
        if (this.g != null && this.g.getAttributeByOid(OidCms.AA_ETS_CERT_VALUES) != null && this.g.getAttributeByOid(OidCms.AA_ETS_REVOCATION_VALUES) != null) {
            n |= 8;
        }
        return n;
    }

    public Certificate searchCertificate(List<Certificate> object) {
        Certificate certificate = null;
        ASN1Integer aSN1Integer = this.b.getIssuerAndSerialNumber().getSerialNumber();
        object = object.iterator();
        while (object.hasNext()) {
            Certificate certificate2 = (Certificate)object.next();
            if (!certificate2.getInfo().getSerialNumber().equals((Object)aSN1Integer)) continue;
            certificate = certificate2;
            break;
        }
        return certificate;
    }

    public static SignerInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (SignerInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Value)this.d);
        aSN1Sequence.addElement((ASN1Value)this.e);
        aSN1Sequence.addElement((ASN1Value)this.f);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.g);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static void checkKeyUsage(Certificate object) throws PKIXException {
        boolean[] blArray = ((Certificate)object).getKeyUsage();
        object = blArray;
        if (blArray != null) {
            if (((Object)object).length == 0 | object[UsageBits.DIGITAL_SIGNATURE.getIndex()] == false) {
                throw new PKIXException("Illegal certificate key usage");
            }
        } else {
            throw new PKIXException("Certificate key usage not specified");
        }
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(SignerIdentifier.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)0L), SetOfAttribute.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)1L), SetOfAttribute.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            Assert.debugAssert(((aSN1Tag = this.getSequence(aSN1Tag, inputStream)).size() == 7 ? 1 : 0) != 0);
            return new SignerInfo((ASN1Integer)aSN1Tag.elementAt(0), (SignerIdentifier)aSN1Tag.elementAt(1), (AlgorithmIdentifier)aSN1Tag.elementAt(2), (SetOfAttribute)aSN1Tag.elementAt(3), (AlgorithmIdentifier)aSN1Tag.elementAt(4), (ASN1OctetString)aSN1Tag.elementAt(5), (SetOfAttribute)aSN1Tag.elementAt(6));
        }
    }
}

