/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.esf;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1UTCTime;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CrlIdentifier
extends AbstractASN1Sequence {
    private Name a;
    private ASN1UTCTime b;
    private ASN1Integer c;
    public static final ASN1Template TEMPLATE = new a();

    public CrlIdentifier(Name name, ASN1UTCTime aSN1UTCTime) {
        super(CrlIdentifier.class);
        PKIXUtils.verifyNotNull(name, aSN1UTCTime);
        this.a = name;
        this.b = aSN1UTCTime;
    }

    public Name getCrlissuer() {
        return this.a;
    }

    public void setCrlissuer(Name name) {
        PKIXUtils.verifyNotNull(name);
        this.a = name;
    }

    public ASN1UTCTime getCrlIssuedTime() {
        return this.b;
    }

    public void setCrlIssuedTime(ASN1UTCTime aSN1UTCTime) {
        PKIXUtils.verifyNotNull(aSN1UTCTime);
        this.b = aSN1UTCTime;
    }

    public ASN1Integer getCrlNumber() {
        return this.c;
    }

    public void setCrlNumber(ASN1Integer aSN1Integer) {
        this.c = aSN1Integer;
    }

    public static CrlIdentifier getInstance(byte[] byArray) throws PKIXException {
        try {
            return (CrlIdentifier)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(Name.TEMPLATE);
            this.seqt.addElement(ASN1UTCTime.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Integer.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = new CrlIdentifier((Name)aSN1Tag.elementAt(0), (ASN1UTCTime)aSN1Tag.elementAt(1));
            ((CrlIdentifier)object).setCrlNumber((ASN1Integer)aSN1Tag.elementAt(2));
            return object;
        }
    }
}

