/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.esf;

import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.esf.CrlIdentifier;
import com.bifit.security.pkix.esf.OtherHashAlgAndValue;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CrlValidatedID
extends AbstractASN1Sequence {
    private OtherHashAlgAndValue a;
    private CrlIdentifier b;
    public static final ASN1Template TEMPLATE = new a();

    public CrlValidatedID(OtherHashAlgAndValue otherHashAlgAndValue) {
        super(CrlValidatedID.class);
        PKIXUtils.verifyNotNull(otherHashAlgAndValue);
        this.a = otherHashAlgAndValue;
    }

    public static CrlValidatedID getInstance(byte[] byArray) throws PKIXException {
        try {
            return (CrlValidatedID)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public OtherHashAlgAndValue getCrlHash() {
        return this.a;
    }

    public void setCrlHash(OtherHashAlgAndValue otherHashAlgAndValue) {
        PKIXUtils.verifyNotNull(otherHashAlgAndValue);
        this.a = otherHashAlgAndValue;
    }

    public CrlIdentifier getCrlIdentifier() {
        return this.b;
    }

    public void setCrlIdentifier(CrlIdentifier crlIdentifier) {
        this.b = crlIdentifier;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(OtherHashAlgAndValue.TEMPLATE);
            this.seqt.addOptionalElement(CrlIdentifier.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = new CrlValidatedID((OtherHashAlgAndValue)aSN1Tag.elementAt(0));
            ((CrlValidatedID)object).setCrlIdentifier((CrlIdentifier)aSN1Tag.elementAt(1));
            return object;
        }
    }
}

