/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.CryptoConverter;
import com.bifit.security.pkix.crypto.SignatureAdapter;
import com.bifit.security.pkix.crypto.VerifyAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.ocsp.ResponseData;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Certificates;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BasicOCSPResponse
extends AbstractASN1Sequence {
    private ResponseData a;
    private AlgorithmIdentifier b;
    private ASN1BitString c;
    private Certificates d;
    public static final ASN1Template TEMPLATE = new a();

    public BasicOCSPResponse(ResponseData responseData, AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        super(BasicOCSPResponse.class);
        this.debug("respData = " + responseData + ", algId = " + algorithmIdentifier + ", signature = " + aSN1BitString);
        PKIXUtils.verifyNotNull(responseData, algorithmIdentifier, aSN1BitString);
        this.a = responseData;
        this.b = algorithmIdentifier;
        this.c = aSN1BitString;
    }

    public BasicOCSPResponse(ResponseData responseData, SignatureAdapter signatureAdapter) throws CryptoException {
        super(BasicOCSPResponse.class);
        this.debug("respData = " + responseData + ", adapter = " + signatureAdapter);
        PKIXUtils.verifyNotNull(responseData, signatureAdapter);
        this.a = responseData;
        this.b = signatureAdapter.getSignatureAlgorithm();
        this.c = CryptoConverter.signBytes2BitString(this.b, signatureAdapter.sign(responseData.encode()));
    }

    public boolean verify(VerifyAdapter verifyAdapter) throws CryptoException, InvalidBERException {
        this.debug("adapter = " + verifyAdapter);
        PKIXUtils.verifyNotNull(verifyAdapter);
        return verifyAdapter.verify(this.a.encode(), CryptoConverter.signBitString2Bytes(verifyAdapter.getSignatureAlgorithm(), this.c));
    }

    public ResponseData getRespData() {
        return this.a;
    }

    public void setRespData(ResponseData responseData) {
        this.debug("respData = " + responseData);
        PKIXUtils.verifyNotNull(responseData);
        this.a = responseData;
    }

    public AlgorithmIdentifier getSignAlg() {
        return this.b;
    }

    public void setSignAlg(AlgorithmIdentifier algorithmIdentifier) {
        this.debug("signAlg = " + algorithmIdentifier);
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.b = algorithmIdentifier;
    }

    public ASN1BitString getSignature() {
        return this.c;
    }

    public void setSignature(ASN1BitString aSN1BitString) {
        this.debug("signature = " + aSN1BitString);
        PKIXUtils.verifyNotNull(aSN1BitString);
        this.c = aSN1BitString;
    }

    public Certificates getCerts() {
        return this.d;
    }

    public void setCerts(Certificates certificates) {
        this.debug("certs = " + certificates);
        this.d = certificates;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.d);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "BasicOCSPResponse [respData=" + this.a + ", signAlg=" + this.b + ", signature=" + this.c + ", certs=" + this.d + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ResponseData.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1BitString.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)Certificates.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (ResponseData)aSN1Tag.elementAt(0);
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)aSN1Tag.elementAt(1);
            ASN1BitString aSN1BitString = (ASN1BitString)aSN1Tag.elementAt(2);
            aSN1Tag = (ASN1Explicit)aSN1Tag.elementAt(3);
            object = new BasicOCSPResponse((ResponseData)object, algorithmIdentifier, aSN1BitString);
            ((BasicOCSPResponse)object).setCerts(aSN1Tag == null ? null : (Certificates)aSN1Tag.getContent());
            return object;
        }
    }
}

