/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Null;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.ocsp.CSType;
import com.bifit.security.pkix.ocsp.RevokedInfo;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CertStatus
extends AbstractASN1Choice {
    private CSType a;
    public static final ASN1Template TEMPLATE = new a();

    public CertStatus(CSType cSType, RevokedInfo revokedInfo) {
        super(CertStatus.class, revokedInfo);
        this.debug("statusType = " + (Object)((Object)cSType) + ", statusValue = " + revokedInfo);
        PKIXUtils.verifyNotNull(new Object[]{cSType});
        if (cSType == CSType.REVOKED && revokedInfo == null) {
            throw new IllegalArgumentException("REVOKED type must contain status info");
        }
        this.a = cSType;
    }

    public CSType getStatusType() {
        return this.a;
    }

    public void setStatusType(CSType cSType) {
        this.debug("statusType = " + (Object)((Object)cSType));
        PKIXUtils.verifyNotNull(new Object[]{cSType});
        if (cSType == CSType.REVOKED && this.value == null) {
            throw new IllegalArgumentException("REVOKED type must contain status info");
        }
        this.a = cSType;
    }

    public RevokedInfo getStatusValue() {
        return (RevokedInfo)this.value;
    }

    public void setStatusValue(RevokedInfo revokedInfo) {
        this.debug("statusValue = " + revokedInfo);
        this.value = revokedInfo;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (this.a == CSType.REVOKED) {
            this.value.encode(this.a.a(), outputStream);
            return;
        }
        new ASN1Null().encode(this.a.a(), outputStream);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.encode(outputStream);
    }

    @Override
    public ASN1Tag getTag() {
        return this.a.a();
    }

    public String toString() {
        return "CertStatus [statusType=" + (Object)((Object)this.a) + ", statusValue=" + this.value + "]";
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            for (CSType cSType : CSType.values()) {
                this.choicet.addElement(cSType.a(), cSType.b());
            }
        }

        public final ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            CSType cSType = CSType.getByTag((inputStream = (ASN1Choice)this.choicet.decode(inputStream)).getTag());
            inputStream = cSType == CSType.REVOKED ? (RevokedInfo)inputStream.getValue() : null;
            return new CertStatus(cSType, (RevokedInfo)((Object)inputStream));
        }
    }
}

