/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.CryptoConverter;
import com.bifit.security.pkix.crypto.SignatureAdapter;
import com.bifit.security.pkix.crypto.VerifyAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.ocsp.TBSRequest;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Certificates;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OCSPSignature
extends AbstractASN1Sequence {
    private AlgorithmIdentifier a;
    private ASN1BitString b;
    private Certificates c;
    public static final ASN1Template TEMPLATE = new a();

    public OCSPSignature(AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        super(OCSPSignature.class);
        this.debug("algId = " + algorithmIdentifier + ", signature = " + aSN1BitString);
        PKIXUtils.verifyNotNull(algorithmIdentifier, aSN1BitString);
        this.a = algorithmIdentifier;
        this.b = aSN1BitString;
    }

    public OCSPSignature(TBSRequest tBSRequest, SignatureAdapter signatureAdapter) throws CryptoException {
        super(OCSPSignature.class);
        this.debug("req = " + tBSRequest + ", adapter = " + signatureAdapter);
        PKIXUtils.verifyNotNull(signatureAdapter, tBSRequest);
        this.a = signatureAdapter.getSignatureAlgorithm();
        this.b = CryptoConverter.signBytes2BitString(this.a, signatureAdapter.sign(tBSRequest.encode()));
    }

    public boolean verify(TBSRequest tBSRequest, VerifyAdapter verifyAdapter) throws CryptoException {
        this.debug("adapter = " + verifyAdapter + ", req = " + tBSRequest);
        PKIXUtils.verifyNotNull(verifyAdapter, tBSRequest);
        try {
            return verifyAdapter.verify(tBSRequest.encode(), CryptoConverter.signBitString2Bytes(verifyAdapter.getSignatureAlgorithm(), this.b));
        }
        catch (InvalidBERException invalidBERException) {
            throw new CryptoException(invalidBERException);
        }
    }

    public AlgorithmIdentifier getAlgId() {
        return this.a;
    }

    public void setAlgId(AlgorithmIdentifier algorithmIdentifier) {
        this.debug("algId = " + algorithmIdentifier);
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.a = algorithmIdentifier;
    }

    public ASN1BitString getSignature() {
        return this.b;
    }

    public void setSignature(ASN1BitString aSN1BitString) {
        this.debug("signature = " + aSN1BitString);
        PKIXUtils.verifyNotNull(aSN1BitString);
        this.b = aSN1BitString;
    }

    public Certificates getCerts() {
        return this.c;
    }

    public void setCerts(Certificates certificates) {
        this.debug("certs = " + certificates);
        this.c = certificates;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "Signature [algId=" + this.a + ", signature=" + this.b + ", certs=" + this.c + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1BitString.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)Certificates.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (AlgorithmIdentifier)aSN1Tag.elementAt(0);
            ASN1BitString aSN1BitString = (ASN1BitString)aSN1Tag.elementAt(1);
            aSN1Tag = (ASN1Explicit)aSN1Tag.elementAt(2);
            object = new OCSPSignature((AlgorithmIdentifier)object, aSN1BitString);
            ((OCSPSignature)object).setCerts(aSN1Tag == null ? null : (Certificates)aSN1Tag.getContent());
            return object;
        }
    }
}

