/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.ocsp.BasicOCSPResponse;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ResponseBytes
extends AbstractASN1Sequence {
    private ASN1ObjectIdentifier a;
    private ASN1OctetString b;
    public static final ASN1Template TEMPLATE = new a();

    public ResponseBytes(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1OctetString aSN1OctetString) {
        super(ResponseBytes.class);
        this.debug("responseType = " + aSN1ObjectIdentifier + ", response = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier, aSN1OctetString);
        this.a = aSN1ObjectIdentifier;
        this.b = aSN1OctetString;
    }

    public ResponseBytes(BasicOCSPResponse basicOCSPResponse) {
        super(ResponseBytes.class);
        this.debug("baseResponse = " + basicOCSPResponse);
        PKIXUtils.verifyNotNull(basicOCSPResponse);
        this.a = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.1");
        this.b = new ASN1OctetString(basicOCSPResponse.encode());
    }

    public ASN1ObjectIdentifier getResponseType() {
        return this.a;
    }

    public void setResponseType(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug("responseType = " + aSN1ObjectIdentifier);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = aSN1ObjectIdentifier;
    }

    public ASN1OctetString getResponse() {
        return this.b;
    }

    public void setResponse(ASN1OctetString aSN1OctetString) {
        this.debug("response = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1OctetString);
        this.b = aSN1OctetString;
    }

    public boolean isBasicResponse() {
        return this.a.equals((Object)new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.1"));
    }

    public BasicOCSPResponse getBasicResponse() throws InvalidBERException {
        return (BasicOCSPResponse)ASN1Util.decode((ASN1Template)BasicOCSPResponse.TEMPLATE, (byte[])this.b.toByteArray());
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "ResponseBytes [responseType=" + this.a + ", response=" + this.b + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            inputStream = (ASN1ObjectIdentifier)aSN1Tag.elementAt(0);
            aSN1Tag = (ASN1OctetString)aSN1Tag.elementAt(1);
            return new ResponseBytes((ASN1ObjectIdentifier)inputStream, (ASN1OctetString)aSN1Tag);
        }
    }
}

