/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1GeneralizedTime;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.ocsp.CertID;
import com.bifit.security.pkix.ocsp.CertStatus;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SingleResponse
extends AbstractASN1Sequence {
    private CertID a;
    private CertStatus b;
    private ASN1GeneralizedTime c;
    private ASN1GeneralizedTime d;
    private Extensions e;
    public static final ASN1Template TEMPLATE = new a();

    public SingleResponse(CertID certID, CertStatus certStatus, ASN1GeneralizedTime aSN1GeneralizedTime) {
        super(SingleResponse.class);
        this.debug("certID = " + certID + ", certStatus = " + certStatus + ", thisUpdate = " + aSN1GeneralizedTime);
        PKIXUtils.verifyNotNull(certID, certStatus, aSN1GeneralizedTime);
        this.a = certID;
        this.b = certStatus;
        this.c = aSN1GeneralizedTime;
    }

    public CertID getCertID() {
        return this.a;
    }

    public void setCertID(CertID certID) {
        this.debug("certID = " + certID);
        PKIXUtils.verifyNotNull(certID);
        this.a = certID;
    }

    public CertStatus getCertStatus() {
        return this.b;
    }

    public void setCertStatus(CertStatus certStatus) {
        this.debug("certStatus = " + certStatus);
        PKIXUtils.verifyNotNull(certStatus);
        this.b = certStatus;
    }

    public ASN1GeneralizedTime getThisUpdate() {
        return this.c;
    }

    public void setThisUpdate(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.debug("thisUpdate = " + aSN1GeneralizedTime);
        PKIXUtils.verifyNotNull(aSN1GeneralizedTime);
        this.c = aSN1GeneralizedTime;
    }

    public ASN1GeneralizedTime getNextUpdate() {
        return this.d;
    }

    public void setNextUpdate(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.debug("nextUpdate = " + aSN1GeneralizedTime);
        this.d = aSN1GeneralizedTime;
    }

    public Extensions getExtensions() {
        return this.e;
    }

    public void setExtensions(Extensions extensions) {
        this.debug("extensions = " + extensions);
        this.e = extensions;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.d);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)1L), (ASN1Value)this.e);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "SingleResponse [certID=" + this.a + ", certStatus=" + this.b + ", thisUpdate=" + this.c + ", nextUpdate=" + this.d + ", extensions=" + this.e + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(CertID.TEMPLATE);
            this.seqt.addElement(CertStatus.TEMPLATE);
            this.seqt.addElement(ASN1GeneralizedTime.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)ASN1GeneralizedTime.TEMPLATE));
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)1L), (ASN1Template)Extensions.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (CertID)aSN1Tag.elementAt(0);
            CertStatus certStatus = (CertStatus)aSN1Tag.elementAt(1);
            ASN1GeneralizedTime aSN1GeneralizedTime = (ASN1GeneralizedTime)aSN1Tag.elementAt(2);
            ASN1Explicit aSN1Explicit = (ASN1Explicit)aSN1Tag.elementAt(3);
            aSN1Tag = (ASN1Explicit)aSN1Tag.elementAt(4);
            object = new SingleResponse((CertID)object, certStatus, aSN1GeneralizedTime);
            ((SingleResponse)object).setNextUpdate(aSN1Explicit == null ? null : (ASN1GeneralizedTime)aSN1Explicit.getContent());
            ((SingleResponse)object).setExtensions(aSN1Tag == null ? null : (Extensions)aSN1Tag.getContent());
            return object;
        }
    }
}

