/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.ocsp.Requests;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.GeneralName;
import com.bifit.security.pkix.x509.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TBSRequest
extends AbstractASN1Sequence {
    private Version a;
    private GeneralName b;
    private Requests c;
    private Extensions d;
    public static final ASN1Template TEMPLATE = new a();

    public TBSRequest(Version version, GeneralName generalName, Requests requests) {
        super(TBSRequest.class);
        this.debug("version = " + (Object)((Object)version) + ", reqName = " + generalName + ", reqList = " + requests);
        this.a = version == null ? Version.v1 : version;
        this.b = generalName;
        this.c = requests == null ? new Requests() : requests;
    }

    public Version getVersion() {
        return this.a;
    }

    public void setVersion(Version version) {
        this.debug("version = " + (Object)((Object)version));
        this.a = version == null ? Version.v1 : version;
    }

    public GeneralName getReqName() {
        return this.b;
    }

    public void setReqName(GeneralName generalName) {
        this.debug("reqName = " + generalName);
        this.b = generalName;
    }

    public Requests getReqList() {
        return this.c;
    }

    public void setReqList(Requests requests) {
        this.debug("reqList = " + requests);
        this.c = requests == null ? new Requests() : requests;
    }

    public Extensions getExts() {
        return this.d;
    }

    public void setExts(Extensions extensions) {
        this.d = extensions;
    }

    public boolean hasRequestorName() {
        return this.b != null;
    }

    public boolean hasExtensions() {
        return this.d != null;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.a != Version.v1) {
            aSN1Sequence.addElement((ASN1Value)new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)this.a.getASNValue()));
        }
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)1L), (ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)2L), (ASN1Value)this.d);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "TBSRequest [version=" + (Object)((Object)this.a) + ", reqName=" + this.b + ", reqList=" + this.c + ", exts=" + this.d + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            ASN1Explicit aSN1Explicit = new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)Version.v1.getASNValue());
            this.seqt.addElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)ASN1Integer.TEMPLATE), (ASN1Value)aSN1Explicit);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)1L), (ASN1Template)GeneralName.TEMPLATE));
            this.seqt.addElement(Requests.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)2L), (ASN1Template)Extensions.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (ASN1Explicit)aSN1Tag.elementAt(0);
            object = Version.fromASNInt((ASN1Integer)object.getContent());
            ASN1Explicit aSN1Explicit = (ASN1Explicit)aSN1Tag.elementAt(1);
            aSN1Explicit = aSN1Explicit == null ? null : (GeneralName)aSN1Explicit.getContent();
            Requests requests = (Requests)aSN1Tag.elementAt(2);
            aSN1Tag = (ASN1Explicit)aSN1Tag.elementAt(3);
            object = new TBSRequest((Version)((Object)object), (GeneralName)aSN1Explicit, requests);
            ((TBSRequest)object).setExts(aSN1Tag == null ? null : (Extensions)aSN1Tag.getContent());
            return object;
        }
    }
}

