/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.pkcs10;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.CryptoConverter;
import com.bifit.security.pkix.crypto.SignatureAdapter;
import com.bifit.security.pkix.crypto.VerifyAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.pkcs10.CertificationRequestInfo;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CertificationRequest
extends AbstractASN1Sequence {
    private final CertificationRequestInfo a;
    private final ASN1BitString b;
    private final AlgorithmIdentifier c;
    public static final ASN1Template TEMPLATE = new a();

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        super(CertificationRequest.class);
        this.debug("info = " + certificationRequestInfo + ", algId = " + algorithmIdentifier + ", signature = " + aSN1BitString);
        PKIXUtils.verifyNotNull(certificationRequestInfo, algorithmIdentifier, aSN1BitString);
        this.a = certificationRequestInfo;
        this.c = algorithmIdentifier;
        this.b = aSN1BitString;
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, SignatureAdapter signatureAdapter) throws CryptoException {
        super(CertificationRequest.class);
        this.debug("info = " + certificationRequestInfo + ", adapter = " + signatureAdapter);
        PKIXUtils.verifyNotNull(certificationRequestInfo, signatureAdapter);
        this.a = certificationRequestInfo;
        this.c = signatureAdapter.getSignatureAlgorithm();
        this.b = CryptoConverter.signBytes2BitString(this.c, signatureAdapter.sign(certificationRequestInfo.encode()));
    }

    public boolean verify(VerifyAdapter verifyAdapter) throws CryptoException, InvalidBERException {
        this.debug("adapter=" + verifyAdapter);
        PKIXUtils.verifyNotNull(verifyAdapter);
        return verifyAdapter.verify(this.a.encode(), CryptoConverter.signBitString2Bytes(verifyAdapter.getSignatureAlgorithm(), this.b));
    }

    public CertificationRequestInfo getInfo() {
        return this.a;
    }

    public AlgorithmIdentifier getAlgId() {
        return this.c;
    }

    public byte[] getSignatureBytes() {
        return this.b.getBits();
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static CertificationRequest getInstance(byte[] byArray) throws PKIXException {
        try {
            return (CertificationRequest)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public String toString() {
        return "CertificationRequest [info=" + this.a + ", signature=" + this.b + ", algId=" + this.c + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(CertificationRequestInfo.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1BitString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream inputStream) throws InvalidBERException, IOException {
            if ((inputStream = (ASN1BitString)(object = this.getSequence((ASN1Tag)object, inputStream)).elementAt(2)).getPadCount() != 0) {
                throw new InvalidBERException("Signature does not fall into an integral number of bytes");
            }
            CertificationRequestInfo certificationRequestInfo = (CertificationRequestInfo)object.elementAt(0);
            object = (AlgorithmIdentifier)object.elementAt(1);
            return new CertificationRequest(certificationRequestInfo, (AlgorithmIdentifier)object, (ASN1BitString)inputStream);
        }
    }
}

