/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.primitive.AbstractASN1Value;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractGenericASN1Sequence<T extends ASN1Value>
extends AbstractASN1Value {
    protected ASN1Sequence sequence;
    public static final ASN1Tag TAG = ASN1Sequence.TAG;

    protected AbstractGenericASN1Sequence(Class<?> clazz) {
        super(clazz);
        this.sequence = new ASN1Sequence();
    }

    protected AbstractGenericASN1Sequence(ASN1Sequence aSN1Sequence, Class<?> clazz) {
        super(clazz);
        this.sequence = aSN1Sequence;
    }

    public void addElement(T t) {
        this.sequence.addElement(t);
    }

    public T elementAt(int n) {
        return (T)this.sequence.elementAt(n);
    }

    public void insertElementAt(T t, int n) {
        this.sequence.insertElementAt(t, n);
    }

    public void removeElementAt(int n) {
        this.sequence.removeElementAt(n);
    }

    public void removeAllElements() {
        this.sequence.removeAllElements();
    }

    public int size() {
        return this.sequence.size();
    }

    public boolean isEmpty() {
        return this.sequence.size() == 0;
    }

    public List<T> asList() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < this.size(); ++i) {
            arrayList.add(this.elementAt(i));
        }
        return arrayList;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(aSN1Tag, outputStream);
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    protected static abstract class AbstractGenericTemplate
    implements ASN1Template {
        protected final ASN1Sequence.OF_Template seqt;

        protected AbstractGenericTemplate(ASN1Template aSN1Template) {
            this.seqt = new ASN1Sequence.OF_Template(aSN1Template);
        }

        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals((Object)aSN1Tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public abstract ASN1Value decode(ASN1Tag var1, InputStream var2) throws InvalidBERException, IOException;
    }
}

