/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.ECBinary;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DSTU4145Params
extends AbstractASN1Sequence {
    private final ASN1Choice a;
    private final ASN1OctetString b;
    public static final ASN1Template TEMPLATE = new a();

    public DSTU4145Params(ASN1Choice aSN1Choice, ASN1OctetString aSN1OctetString) {
        super(DSTU4145Params.class);
        this.debug("ecparams = " + aSN1Choice + ", dke = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1Choice);
        this.a = aSN1Choice;
        this.b = aSN1OctetString;
    }

    public DSTU4145Params(ASN1Choice aSN1Choice) {
        this(aSN1Choice, null);
    }

    public ASN1Choice getEcparams() {
        return this.a;
    }

    public ASN1OctetString getDke() {
        return this.b;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static DSTU4145Params getInstance(byte[] byArray) throws PKIXException {
        try {
            return (DSTU4145Params)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public String toString() {
        return "DSTU4145Params [ecparams=" + this.a + ", dke=" + this.b + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            ASN1Choice.Template template = new ASN1Choice.Template();
            template.addElement(ECBinary.TEMPLATE);
            template.addElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addElement((ASN1Template)template);
            this.seqt.addOptionalElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            ASN1Sequence.Template template = new ASN1Sequence.Template();
            ASN1Choice.Template template2 = new ASN1Choice.Template();
            template2.addElement(ECBinary.TEMPLATE);
            template2.addElement(ASN1ObjectIdentifier.TEMPLATE);
            template.addElement((ASN1Template)template2);
            template.addOptionalElement(ASN1OctetString.TEMPLATE);
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            inputStream = (ASN1Choice)aSN1Tag.elementAt(0);
            aSN1Tag = (ASN1OctetString)aSN1Tag.elementAt(1);
            return new DSTU4145Params((ASN1Choice)inputStream, (ASN1OctetString)aSN1Tag);
        }
    }
}

