/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ECDHParameters
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final ASN1Integer b;
    private final ASN1Integer c;
    private final ASN1Integer d;
    private final ASN1OctetString e;
    private final ASN1Integer f;
    private final ASN1Integer g;
    private final ASN1OctetString h;
    public static final ASN1Template TEMPLATE = new a();

    public ECDHParameters(ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2, ASN1Integer aSN1Integer3, ASN1Integer aSN1Integer4, ASN1OctetString aSN1OctetString, ASN1Integer aSN1Integer5, ASN1Integer aSN1Integer6, ASN1OctetString aSN1OctetString2) {
        super(ECDHParameters.class);
        this.debug("q = " + aSN1Integer + ", fr = " + aSN1Integer2 + ", a = " + aSN1Integer3 + ", b = " + aSN1Integer4 + ", g = " + aSN1OctetString + ", n = " + aSN1Integer5 + ", h = " + aSN1Integer6 + ", dke = " + aSN1OctetString2);
        PKIXUtils.verifyNotNull(aSN1Integer, aSN1Integer2, aSN1Integer3, aSN1Integer4, aSN1OctetString, aSN1Integer5, aSN1Integer6);
        this.a = aSN1Integer;
        this.b = aSN1Integer2;
        this.c = aSN1Integer3;
        this.d = aSN1Integer4;
        this.e = aSN1OctetString;
        this.f = aSN1Integer5;
        this.g = aSN1Integer6;
        this.h = aSN1OctetString2;
    }

    public ASN1Integer getQ() {
        return this.a;
    }

    public ASN1Integer getFR() {
        return this.b;
    }

    public ASN1Integer getA() {
        return this.c;
    }

    public ASN1Integer getB() {
        return this.d;
    }

    public ASN1OctetString getG() {
        return this.e;
    }

    public ASN1Integer getN() {
        return this.f;
    }

    public ASN1Integer getH() {
        return this.g;
    }

    public ASN1OctetString getDke() {
        return this.h;
    }

    public static ECDHParameters getInstance(byte[] byArray) throws PKIXException {
        try {
            return (ECDHParameters)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.addElement((ASN1Value)this.e);
        aSN1Sequence.addElement((ASN1Value)this.f);
        aSN1Sequence.addElement((ASN1Value)this.g);
        aSN1Sequence.addOptionalElement((ASN1Value)this.h);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addOptionalElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new ECDHParameters((ASN1Integer)aSN1Tag.elementAt(0), (ASN1Integer)aSN1Tag.elementAt(1), (ASN1Integer)aSN1Tag.elementAt(2), (ASN1Integer)aSN1Tag.elementAt(3), (ASN1OctetString)aSN1Tag.elementAt(4), (ASN1Integer)aSN1Tag.elementAt(5), (ASN1Integer)aSN1Tag.elementAt(6), (ASN1OctetString)aSN1Tag.elementAt(7));
        }
    }
}

