/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GOST34310ValidationParms
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final ASN1Integer b;
    private final ASN1Integer c;
    public static final ASN1Template TEMPLATE = new a();

    public GOST34310ValidationParms(ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2, ASN1Integer aSN1Integer3) {
        super(GOST34310ValidationParms.class);
        this.debug("x0 = " + aSN1Integer + ", c = " + aSN1Integer2 + ", d = " + aSN1Integer3);
        PKIXUtils.verifyNotNull(aSN1Integer, aSN1Integer2);
        this.a = aSN1Integer;
        this.b = aSN1Integer2;
        this.c = aSN1Integer3;
    }

    public ASN1Integer getX0() {
        return this.a;
    }

    public ASN1Integer getC() {
        return this.b;
    }

    public ASN1Integer getD() {
        return this.c;
    }

    public static GOST34310ValidationParms getInstance(byte[] byArray) throws PKIXException {
        try {
            return (GOST34310ValidationParms)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Integer.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new GOST34310ValidationParms((ASN1Integer)aSN1Tag.elementAt(0), (ASN1Integer)aSN1Tag.elementAt(1), (ASN1Integer)aSN1Tag.elementAt(2));
        }
    }
}

