/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.GeneralName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AccessDescription
extends AbstractASN1Sequence {
    private ASN1ObjectIdentifier a;
    private GeneralName b;
    public static final ASN1Template TEMPLATE = new a();

    public AccessDescription(ASN1ObjectIdentifier aSN1ObjectIdentifier, GeneralName generalName) {
        super(AccessDescription.class);
        this.debug("accessMethod = " + aSN1ObjectIdentifier + ", accessLocation = " + generalName);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier, generalName);
        this.a = aSN1ObjectIdentifier;
        this.b = generalName;
    }

    public void setAccessMethod(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug("accessMethod = " + aSN1ObjectIdentifier);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = aSN1ObjectIdentifier;
    }

    public ASN1ObjectIdentifier getAccessMethod() {
        return this.a;
    }

    public void setAccessLocation(GeneralName generalName) {
        this.debug("accessLocation = " + generalName);
        PKIXUtils.verifyNotNull(generalName);
        this.b = generalName;
    }

    public GeneralName getAccessLocation() {
        return this.b;
    }

    public boolean isOCSP() {
        return "1.3.6.1.5.5.7.48.1".equals(this.a.toString());
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "AccessDescription [accessMethod=" + this.a + ", accessLocation=" + this.b + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addElement((ASN1Template)GeneralName.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream inputStream) throws IOException, InvalidBERException {
            object = this.getSequence((ASN1Tag)object, inputStream);
            inputStream = (ASN1ObjectIdentifier)object.elementAt(0);
            object = (GeneralName)object.elementAt(1);
            return new AccessDescription((ASN1ObjectIdentifier)inputStream, (GeneralName)object);
        }
    }
}

