/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AlgorithmIdentifier
extends AbstractASN1Sequence {
    private ASN1ObjectIdentifier a;
    private ASN1Value b;
    public static final ASN1Template TEMPLATE = new a();

    public AlgorithmIdentifier(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(AlgorithmIdentifier.class);
        this.debug("oid = " + aSN1ObjectIdentifier);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = aSN1ObjectIdentifier;
    }

    public AlgorithmIdentifier(String string) {
        super(AlgorithmIdentifier.class);
        this.debug("algorithm = " + string);
        PKIXUtils.verifyNotNull(string);
        this.a = new ASN1ObjectIdentifier(string);
    }

    public void setAlgorithm(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug("oid = " + aSN1ObjectIdentifier);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = aSN1ObjectIdentifier;
    }

    public ASN1ObjectIdentifier getAlgorithm() {
        return this.a;
    }

    public String getOID() {
        return this.a.toString();
    }

    public void setParameters(ASN1Value aSN1Value) {
        this.debug("parameters = " + aSN1Value);
        this.b = aSN1Value;
    }

    public ASN1Value getParameters() {
        return this.b;
    }

    public static AlgorithmIdentifier getInstance(byte[] byArray) throws PKIXException {
        try {
            return (AlgorithmIdentifier)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalElement(this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "AlgorithmIdentifier [oid=" + this.a + ", parameters=" + this.b + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Any.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (ASN1ObjectIdentifier)aSN1Tag.elementAt(0);
            aSN1Tag = aSN1Tag.elementAt(1);
            object = new AlgorithmIdentifier((ASN1ObjectIdentifier)object);
            ((AlgorithmIdentifier)object).setParameters((ASN1Value)aSN1Tag);
            return object;
        }
    }
}

