/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.AttributeCertificateInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AttributeCertificate
extends AbstractASN1Sequence {
    private AttributeCertificateInfo a;
    private AlgorithmIdentifier b;
    private ASN1BitString c;
    public static final ASN1Template TEMPLATE = new a();

    public AttributeCertificate(AttributeCertificateInfo attributeCertificateInfo, AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        super(AttributeCertificate.class);
        PKIXUtils.verifyNotNull(attributeCertificateInfo, algorithmIdentifier, aSN1BitString);
        this.a = attributeCertificateInfo;
        this.b = algorithmIdentifier;
        this.c = aSN1BitString;
    }

    public AttributeCertificateInfo getAcinfo() {
        return this.a;
    }

    public void setAcinfo(AttributeCertificateInfo attributeCertificateInfo) {
        PKIXUtils.verifyNotNull(attributeCertificateInfo);
        this.a = attributeCertificateInfo;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.b;
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.b = algorithmIdentifier;
    }

    public ASN1BitString getSignatureValue() {
        return this.c;
    }

    public void setSignatureValue(ASN1BitString aSN1BitString) {
        PKIXUtils.verifyNotNull(aSN1BitString);
        this.c = aSN1BitString;
    }

    public static AttributeCertificate getInstance(byte[] byArray) throws PKIXException {
        try {
            return (AttributeCertificate)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(AttributeCertificateInfo.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1BitString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new AttributeCertificate((AttributeCertificateInfo)aSN1Tag.elementAt(0), (AlgorithmIdentifier)aSN1Tag.elementAt(1), (ASN1BitString)aSN1Tag.elementAt(2));
        }
    }
}

