/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Primitive;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.log.LogKey;
import com.bifit.security.pkix.log.LogParam;
import com.bifit.security.pkix.log.PKIXLogger;
import com.bifit.security.pkix.log.PKIXLoggerFactory;
import com.bifit.security.pkix.x509.GeneralNames;
import com.bifit.security.pkix.x509.RelativeDistinguishedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DistributionPointName
extends AbstractASN1Primitive {
    private final ASN1Choice a;
    public static final ASN1Template TEMPLATE = new a();
    private static final PKIXLogger b = PKIXLoggerFactory.getLogger(DistributionPointName.class);

    public DistributionPointName(GeneralNames generalNames) {
        b.debug("fullName = " + generalNames);
        this.a = new ASN1Choice(ASN1Tag.get((long)0L), (ASN1Value)generalNames);
    }

    public DistributionPointName(RelativeDistinguishedName relativeDistinguishedName) {
        b.debug("nameRelativeToCRLIssuer = " + relativeDistinguishedName);
        this.a = new ASN1Choice(ASN1Tag.get((long)1L), (ASN1Value)relativeDistinguishedName);
    }

    public ASN1Choice getValue() {
        return this.a;
    }

    public boolean isFullName() {
        return this.a.getTag().equals((Object)ASN1Tag.get((long)0L));
    }

    public boolean isRelativeToCRLIss() {
        return this.a.getTag().equals((Object)ASN1Tag.get((long)1L));
    }

    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.a.encode(aSN1Tag, outputStream);
    }

    public ASN1Tag getTag() {
        return this.a.getTag();
    }

    public String toString() {
        return "DistributionPointName [value=" + this.a + "]";
    }

    private static final class a
    implements ASN1Template {
        private final ASN1Choice.Template a = new ASN1Choice.Template();

        public a() {
            this.a.addElement(ASN1Tag.get((long)0L), GeneralNames.TEMPLATE);
            this.a.addElement(ASN1Tag.get((long)1L), RelativeDistinguishedName.TEMPLATE);
        }

        public final boolean tagMatch(ASN1Tag aSN1Tag) {
            b.debug(LogParam.print(new LogParam(LogKey.TAG, aSN1Tag)));
            return this.a.tagMatch(aSN1Tag);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            if ((inputStream = (ASN1Choice)this.a.decode(inputStream)).getValue() instanceof GeneralNames) {
                return new DistributionPointName((GeneralNames)inputStream.getValue());
            }
            if (inputStream.getValue() instanceof RelativeDistinguishedName) {
                return new DistributionPointName((RelativeDistinguishedName)inputStream.getValue());
            }
            throw new InvalidBERException("Illegal value");
        }

        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            b.warn(LogParam.form("A ASN1Choice cannot be implicitly tagged"));
            return this.decode(inputStream);
        }
    }
}

