/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.Time;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Calendar;
import java.util.Date;

public class Validity
extends AbstractASN1Sequence {
    private final Time a;
    private final Time b;
    public static final ASN1Template TEMPLATE = new a();

    public Validity(Date date, Date date2) {
        super(Validity.class);
        this.debug("notBefore = " + date + ", notAfter = " + date2);
        PKIXUtils.verifyNotNull(date, date2);
        this.a = new Time(date);
        this.b = new Time(date2);
    }

    public Validity(Time time, Time time2) {
        super(Validity.class);
        this.debug("notBefore = " + time + ", notAfter = " + time2);
        PKIXUtils.verifyNotNull(time, time2);
        this.a = time;
        this.b = time2;
    }

    public Validity(long l) {
        super(Validity.class);
        this.debug("validTimeMs = " + l);
        Comparable<Calendar> comparable = Calendar.getInstance();
        ((Calendar)comparable).set(14, 0);
        comparable = ((Calendar)comparable).getTime();
        Date date = new Date(((Date)comparable).getTime() + l);
        this.a = new Time((Date)comparable);
        this.b = new Time(date);
    }

    public Time getNotBefore() {
        return this.a;
    }

    public Time getNotAfter() {
        return this.b;
    }

    public boolean isValid(Time object) {
        this.debug("when = " + object);
        object = ((Time)object).toDate();
        return !((Date)object).before(this.a.toDate()) && !((Date)object).after(this.b.toDate());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.debug("date = " + date);
        if (date.after(this.b.toDate())) {
            throw new CertificateExpiredException();
        }
        if (date.before(this.a.toDate())) {
            throw new CertificateNotYetValidException();
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static Validity getInstance(byte[] byArray) throws PKIXException {
        try {
            return (Validity)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public String toString() {
        return "Validity [notBefore=" + this.a.toDate() + ", notAfter=" + this.b.toDate() + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement((ASN1Template)Time.TEMPLATE);
            this.seqt.addElement((ASN1Template)Time.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new Validity((Time)aSN1Tag.elementAt(0), (Time)aSN1Tag.elementAt(1));
        }
    }
}

