/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.GeneratorException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.exception.ValidateException;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.GeneralNames;
import com.bifit.security.pkix.x509.KeyIdentifier;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class AuthorityKeyIdentifier
extends BaseExtension {
    private KeyIdentifier a;
    private GeneralNames b;
    private ASN1Integer c;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.35");
    private static final ASN1Sequence.Template d = ASN1Sequence.getSequenceTemplate();

    public AuthorityKeyIdentifier(Extension extension) throws InvalidBERException {
        super(extension, AuthorityKeyIdentifier.class, OID);
        extension = ASN1Sequence.getInstance((ASN1Template)d, (byte[])extension.getContent());
        this.a = new KeyIdentifier((ASN1OctetString)extension.elementAt(0));
        this.b = (GeneralNames)extension.elementAt(1);
        this.c = (ASN1Integer)extension.elementAt(2);
        this.debug("keyId=" + (Object)((Object)this.a) + ", generalNames=" + this.b + ", certSN=" + this.c);
    }

    public AuthorityKeyIdentifier(KeyIdentifier keyIdentifier, GeneralNames generalNames, ASN1Integer aSN1Integer) throws GeneratorException {
        super(AuthorityKeyIdentifier.class);
        this.debug("kid = " + (Object)((Object)keyIdentifier) + ", authCerIss = " + generalNames + ", certSerNumber = " + aSN1Integer);
        this.a = keyIdentifier;
        this.b = generalNames;
        this.c = aSN1Integer;
        if (this.b == null ^ this.c == null) {
            throw new GeneratorException("authCerIss and certSerNumber shall both be present or both be absent");
        }
    }

    public void setGeneralNames(GeneralNames generalNames) throws ValidateException {
        this.debug("generalNames = " + generalNames);
        if (generalNames == null ^ this.c == null) {
            throw new ValidateException("authCerIss and certSerNumber shall both be present or both be absent");
        }
        this.b = generalNames;
    }

    public GeneralNames getGeneralNames() {
        return this.b;
    }

    public void setKeyIdentifier(KeyIdentifier keyIdentifier) {
        this.debug("keyIdentifier = " + (Object)((Object)keyIdentifier));
        this.a = keyIdentifier;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.a;
    }

    public void setAuthorityCertSerialNumber(ASN1Integer aSN1Integer) throws PKIXException {
        this.debug("authorityCertSerialNumber = " + aSN1Integer);
        if (this.b == null ^ aSN1Integer == null) {
            throw new PKIXException("authCerIss and certSerNumber shall both be present or both be absent");
        }
        this.c = aSN1Integer;
    }

    public ASN1Integer getAuthorityCertSerialNumber() {
        return this.c;
    }

    @Override
    public Extension getExtension(boolean bl) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Value)this.a);
        if (this.b != null && this.c != null) {
            aSN1Sequence.addElement(ASN1Tag.get((long)1L), (ASN1Value)this.b);
            aSN1Sequence.addElement(ASN1Tag.get((long)2L), (ASN1Value)this.c);
        }
        return this.buildExtension(OID, bl, aSN1Sequence.encode());
    }

    public int hashCode() {
        int n = 31 + (this.c == null ? 0 : this.c.hashCode());
        n = n * 31 + (this.b == null ? 0 : this.b.hashCode());
        n = n * 31 + (this.a == null ? 0 : this.a.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (AuthorityKeyIdentifier)object;
        if (this.c == null ? ((AuthorityKeyIdentifier)object).c != null : !this.c.equals((Object)((AuthorityKeyIdentifier)object).c)) {
            return false;
        }
        if (this.b == null ? ((AuthorityKeyIdentifier)object).b != null : !this.b.equals(((AuthorityKeyIdentifier)object).b)) {
            return false;
        }
        return !(this.a == null ? ((AuthorityKeyIdentifier)object).a != null : !this.a.equals((Object)((AuthorityKeyIdentifier)object).a));
    }

    public String toString() {
        return "AuthorityKeyIdentifier [keyIdentifier=" + (Object)((Object)this.a) + ", generalNames=" + this.b + ", authorityCertSerialNumber=" + this.c + "]";
    }

    static {
        d.addOptionalElement(ASN1Tag.get((long)0L), ASN1OctetString.TEMPLATE);
        d.addOptionalElement(ASN1Tag.get((long)1L), GeneralNames.TEMPLATE);
        d.addOptionalElement(ASN1Tag.get((long)2L), ASN1Integer.TEMPLATE);
    }
}

