/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.pkix.log.DebugLogger;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;

public abstract class BaseExtension
extends DebugLogger {
    public BaseExtension(Extension extension, Class<?> clazz, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(clazz);
        this.debug("EXTENSION = " + extension);
        PKIXUtils.verifyNotNull(extension);
        extension = extension.getOID();
        if (!aSN1ObjectIdentifier.equals((Object)extension)) {
            throw new IllegalArgumentException(String.format("Illegal extension. Expected %s, found %s", aSN1ObjectIdentifier, extension));
        }
    }

    public BaseExtension(Class<?> clazz) {
        super(clazz);
    }

    public abstract Extension getExtension(boolean var1);

    protected Extension buildExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, byte[] object) {
        this.debug("CRITICAL = " + bl);
        object = new ASN1OctetString(object);
        return new Extension(aSN1ObjectIdentifier, bl, (ASN1OctetString)object);
    }
}

