/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1Boolean;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.GeneratorException;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class BasicConstraints
extends BaseExtension {
    private boolean a;
    private final int b;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.19");
    private static final ASN1Sequence.Template c = ASN1Sequence.getSequenceTemplate();

    public BasicConstraints(Extension extension) throws GeneratorException {
        super(extension, BasicConstraints.class, OID);
        try {
            extension = ASN1Sequence.getInstance((ASN1Template)c, (byte[])extension.getContent());
            this.a = ((ASN1Boolean)extension.elementAt(0)).toBoolean();
            if (extension.elementAt(1) != null) {
                this.b = ((ASN1Integer)extension.elementAt(1)).intValue();
                return;
            }
            this.b = 0;
        }
        catch (InvalidBERException invalidBERException) {
            throw new GeneratorException("Basic constraints generating error", (Throwable)invalidBERException);
        }
    }

    public BasicConstraints(boolean bl, int n) {
        super(BasicConstraints.class);
        this.debug("ca = " + bl + ", pathLenConstraint = " + n);
        this.a = bl;
        if (n >= 0) {
            this.b = n;
            return;
        }
        throw new IllegalArgumentException("Path lenght must be not negative");
    }

    public void setCA(boolean bl) {
        this.a = bl;
    }

    public boolean isCA() {
        return this.a;
    }

    public int getPathLenConstraint() {
        return this.b;
    }

    @Override
    public Extension getExtension(boolean bl) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.a) {
            aSN1Sequence.addElement((ASN1Value)new ASN1Boolean(this.a));
            aSN1Sequence.addElement((ASN1Value)new ASN1Integer((long)this.b));
        }
        return this.buildExtension(OID, bl, aSN1Sequence.encode());
    }

    public int hashCode() {
        int n = 31 + (this.a ? 1231 : 1237);
        n = n * 31 + this.b;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (BasicConstraints)object;
        if (this.a != ((BasicConstraints)object).a) {
            return false;
        }
        return this.b == ((BasicConstraints)object).b;
    }

    public String toString() {
        return "BasicConstraints [cA=" + this.a + ", pathLenConstraint=" + this.b + "]";
    }

    static {
        c.addElement(ASN1Boolean.TEMPLATE, (ASN1Value)new ASN1Boolean(false));
        c.addOptionalElement(ASN1Integer.TEMPLATE);
    }
}

