/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.x509.DistributionPoint;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.DistributionPoints;
import java.util.Collection;

public class CRLDistributionPoints
extends DistributionPoints {
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.31");

    public CRLDistributionPoints(DistributionPoint distributionPoint) {
        super(distributionPoint);
    }

    public CRLDistributionPoints(Extension extension) throws InvalidBERException {
        super(extension, OID);
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.points.encode());
    }

    @Override
    public String toString() {
        return "CRLDistributionPoints [points=" + this.points + "]";
    }

    public static CRLDistributionPoints initFrom(Collection<DistributionPoint> object) throws IllegalArgumentException {
        if (object.isEmpty()) {
            throw new IllegalArgumentException("points is empty");
        }
        DistributionPoints distributionPoints = null;
        object = object.iterator();
        while (object.hasNext()) {
            DistributionPoint distributionPoint = (DistributionPoint)object.next();
            if (distributionPoints == null) {
                distributionPoints = new CRLDistributionPoints(distributionPoint);
                continue;
            }
            distributionPoints.addPoint(distributionPoint);
        }
        return distributionPoints;
    }
}

