/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.PolicyInformation;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class CertificatePolicies
extends BaseExtension {
    private final ASN1Sequence a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.32");
    private static final ASN1Sequence.OF_Template b = ASN1Sequence.getSequenceTemplate((ASN1Template)PolicyInformation.TEMPLATE);

    public CertificatePolicies(PolicyInformation policyInformation) {
        super(CertificatePolicies.class);
        this.debug("initial = " + policyInformation);
        PKIXUtils.verifyNotNull(policyInformation);
        this.a = new ASN1Sequence();
        this.a.addElement((ASN1Value)policyInformation);
    }

    public CertificatePolicies(Extension extension) throws InvalidBERException {
        super(extension, CertificatePolicies.class, OID);
        this.a = ASN1Sequence.getInstance((ASN1Template)b, (byte[])extension.getContent());
    }

    public void addElement(PolicyInformation policyInformation) {
        this.debug("info = " + policyInformation);
        PKIXUtils.verifyNotNull(policyInformation);
        this.a.addElement((ASN1Value)policyInformation);
    }

    public PolicyInformation elementAt(int n) {
        this.debug("INDEX = " + n);
        return (PolicyInformation)this.a.elementAt(n);
    }

    public void insertElementAt(PolicyInformation policyInformation, int n) {
        this.debug("info = " + policyInformation + ", index = " + n);
        PKIXUtils.verifyNotNull(policyInformation);
        this.a.insertElementAt((ASN1Value)policyInformation, n);
    }

    public void removeElementAt(int n) {
        this.debug("INDEX = " + n);
        if (this.a.size() == 1) {
            throw new IllegalStateException("Must contain at least 1 element");
        }
        this.a.removeElementAt(n);
    }

    public int size() {
        return this.a.size();
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.a.encode());
    }

    public int hashCode() {
        return 31 + (this.a == null ? 0 : this.a.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (CertificatePolicies)object;
        return !(this.a == null ? ((CertificatePolicies)object).a != null : !this.a.equals((Object)((CertificatePolicies)object).a));
    }

    public String toString() {
        return "CertificatePolicies [sequence=" + this.a + "]";
    }
}

