/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1GeneralizedTime;
import com.bifit.security.asn1.ASN1IA5String;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class CrlID
extends BaseExtension {
    private ASN1IA5String a;
    private ASN1Integer b;
    private ASN1GeneralizedTime c;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.3");
    private static final ASN1Sequence.Template d = new ASN1Sequence.Template();

    public CrlID(Extension extension) throws InvalidBERException {
        super(extension, CrlID.class, OID);
        extension = ASN1Sequence.getInstance((ASN1Template)d, (byte[])extension.getContent());
        ASN1Explicit aSN1Explicit = (ASN1Explicit)extension.elementAt(0);
        ASN1Explicit aSN1Explicit2 = (ASN1Explicit)extension.elementAt(1);
        extension = (ASN1Explicit)extension.elementAt(2);
        if (aSN1Explicit != null) {
            this.a = (ASN1IA5String)aSN1Explicit.getContent();
        }
        if (aSN1Explicit2 != null) {
            this.b = (ASN1Integer)aSN1Explicit2.getContent();
        }
        if (extension != null) {
            this.c = (ASN1GeneralizedTime)extension.getContent();
        }
    }

    public CrlID(ASN1IA5String aSN1IA5String, ASN1Integer aSN1Integer, ASN1GeneralizedTime aSN1GeneralizedTime) {
        super(CrlID.class);
        this.debug("crlURL = " + aSN1IA5String + ", crlNum = " + aSN1Integer + ", crlTime = " + aSN1GeneralizedTime);
        this.a = aSN1IA5String;
        this.b = aSN1Integer;
        this.c = aSN1GeneralizedTime;
    }

    public ASN1IA5String getCrlURL() {
        return this.a;
    }

    public void setCrlURL(ASN1IA5String aSN1IA5String) {
        this.a = aSN1IA5String;
    }

    public ASN1Integer getCrlNum() {
        return this.b;
    }

    public void setCrlNum(ASN1Integer aSN1Integer) {
        this.b = aSN1Integer;
    }

    public ASN1GeneralizedTime getCrlTime() {
        return this.c;
    }

    public void setCrlTime(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.c = aSN1GeneralizedTime;
    }

    @Override
    public Extension getExtension(boolean bl) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.a);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)1L), (ASN1Value)this.b);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)2L), (ASN1Value)this.c);
        return this.buildExtension(OID, bl, aSN1Sequence.encode());
    }

    public int hashCode() {
        int n = 31 + (this.b == null ? 0 : this.b.hashCode());
        n = n * 31 + (this.c == null ? 0 : this.c.hashCode());
        n = n * 31 + (this.a == null ? 0 : this.a.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (CrlID)object;
        if (this.b == null ? ((CrlID)object).b != null : !this.b.equals((Object)((CrlID)object).b)) {
            return false;
        }
        if (this.c == null ? ((CrlID)object).c != null : !this.c.equals((Object)((CrlID)object).c)) {
            return false;
        }
        return !(this.a == null ? ((CrlID)object).a != null : !this.a.equals((Object)((CrlID)object).a));
    }

    public String toString() {
        return "CrlID [crlURL=" + this.a + ", crlNum=" + this.b + ", crlTime=" + this.c + "]";
    }

    static {
        d.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)ASN1IA5String.TEMPLATE));
        d.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)1L), (ASN1Template)ASN1Integer.TEMPLATE));
        d.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)2L), (ASN1Template)ASN1GeneralizedTime.TEMPLATE));
    }
}

