/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AccessDescription;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public abstract class InfoAccess
extends BaseExtension {
    protected ASN1Sequence sequence;
    private static final ASN1Sequence.OF_Template a = ASN1Sequence.getSequenceTemplate((ASN1Template)AccessDescription.TEMPLATE);

    protected InfoAccess(AccessDescription accessDescription) {
        super(InfoAccess.class);
        this.debug("initial = " + accessDescription);
        PKIXUtils.verifyNotNull(accessDescription);
        this.sequence = new ASN1Sequence();
        this.sequence.addElement((ASN1Value)accessDescription);
    }

    protected InfoAccess(Extension extension, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws InvalidBERException {
        super(extension, InfoAccess.class, aSN1ObjectIdentifier);
        this.sequence = ASN1Sequence.getInstance((ASN1Template)a, (byte[])extension.getContent());
    }

    public void addElement(AccessDescription accessDescription) {
        this.debug("element = " + accessDescription);
        PKIXUtils.verifyNotNull(accessDescription);
        this.sequence.addElement((ASN1Value)accessDescription);
    }

    public AccessDescription elementAt(int n) {
        this.debug("INDEX = " + n);
        return (AccessDescription)this.sequence.elementAt(n);
    }

    public void insertElementAt(AccessDescription accessDescription, int n) {
        this.debug("element = " + accessDescription + ", index = " + n);
        PKIXUtils.verifyNotNull(accessDescription);
        this.sequence.insertElementAt((ASN1Value)accessDescription, n);
    }

    public void removeElementAt(int n) {
        this.debug("INDEX = " + n);
        if (this.sequence.size() == 1) {
            throw new IllegalStateException("Sequence must contain at leasn 1 element");
        }
        this.sequence.removeElementAt(n);
    }

    public int size() {
        return this.sequence.size();
    }

    public int hashCode() {
        return 31 + (this.sequence == null ? 0 : this.sequence.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (InfoAccess)object;
        return !(this.sequence == null ? ((InfoAccess)object).sequence != null : !this.sequence.equals((Object)((InfoAccess)object).sequence));
    }

    public String toString() {
        return "InfoAccess [sequence=" + this.sequence + "]";
    }
}

