/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import com.bifit.security.util.AssertionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class ASN1Any
extends AbstractASN1Value {
    private byte[] encoded;
    private ASN1Tag tag;
    private Header header;
    private byte[] contents;
    public static final ASN1Template TEMPLATE = new Template();

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ASN1Any)) {
            return false;
        }
        ASN1Any aSN1Any = (ASN1Any)object;
        return this.tag.equals(aSN1Any.tag) && Arrays.equals(this.encoded, aSN1Any.encoded);
    }

    @Override
    public int hashCode() {
        return this.getTag().hashCode() + Arrays.hashCode(ASN1Util.encode(this));
    }

    public ASN1Any(ASN1Tag aSN1Tag, byte[] byArray) {
        this.encoded = ASN1Util.copy(byArray);
        this.tag = aSN1Tag;
    }

    public ASN1Any(byte[] byArray) throws InvalidBERException {
        try {
            this.encoded = ASN1Util.copy(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Header header = new Header(byteArrayInputStream);
            this.tag = header.getTag();
        }
        catch (IOException iOException) {
            throw new AssertionException("IOException while creating ASN1Any: " + iOException);
        }
    }

    @Override
    public ASN1Tag getTag() {
        return this.tag;
    }

    public byte[] getEncoded() {
        return ASN1Util.copy(this.encoded);
    }

    public Header getHeader() throws InvalidBERException, IOException {
        if (this.header == null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
            this.header = new Header(byteArrayInputStream);
        }
        return this.header;
    }

    public byte[] getContents() throws InvalidBERException {
        try {
            if (this.contents == null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
                this.header = new Header(byteArrayInputStream);
                this.contents = new byte[byteArrayInputStream.available()];
                if ((long)this.contents.length != this.header.getContentLength() && this.header.getContentLength() != -1L) {
                    throw new InvalidBERException("Length of contents was not the same as the header predicted");
                }
                ASN1Util.readFully(this.contents, byteArrayInputStream);
            }
            return ASN1Util.copy(this.contents);
        }
        catch (IOException iOException) {
            Assert.notReached("IOException reading from byte array");
            return null;
        }
    }

    public static ASN1Any getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1Any)ASN1Util.decode(TEMPLATE, byArray);
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encoded);
    }

    public ASN1Value decodeWith(ASN1Template aSN1Template) throws InvalidBERException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
            return aSN1Template.decode(byteArrayInputStream);
        }
        catch (IOException iOException) {
            Assert.notReached("IOException while reading from byte array input stream");
            return null;
        }
    }

    public ASN1Value decodeWith(ASN1Tag aSN1Tag, ASN1Template aSN1Template) throws IOException, InvalidBERException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
        return aSN1Template.decode(aSN1Tag, byteArrayInputStream);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        if (!aSN1Tag.equals(this.tag)) {
            Assert.notReached("No implicit tags allowed for ASN1Any");
        }
        outputStream.write(this.encoded);
    }

    public void encodeWithAlternateTag(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException, InvalidBERException {
        Header header;
        byte[] byArray = this.getContents();
        Assert.debugAssert((long)byArray.length == (header = this.getHeader()).getContentLength());
        Header header2 = new Header(aSN1Tag, header.getForm(), byArray.length);
        header2.encode(outputStream);
        outputStream.write(byArray);
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return true;
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            try {
                Header header = Header.lookAhead(inputStream);
                if (header.getContentLength() == -1L) {
                    ASN1Any aSN1Any;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    header = new Header(inputStream);
                    byteArrayOutputStream.write(header.encode());
                    Template template = new Template();
                    do {
                        aSN1Any = (ASN1Any)template.decode(inputStream);
                        byteArrayOutputStream.write(aSN1Any.getEncoded());
                    } while (!aSN1Any.getTag().equals(ASN1Tag.EOC));
                    return new ASN1Any(header.getTag(), byteArrayOutputStream.toByteArray());
                }
                byte[] byArray = new byte[(int)header.getTotalLength()];
                ASN1Util.readFully(byArray, inputStream);
                return new ASN1Any(header.getTag(), byArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ASN1Any");
            }
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            throw new InvalidBERException("Implicit tag on ASN1Any");
        }
    }
}

