/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.AbstractASN1CharacterString;
import com.bifit.security.asn1.CharConverter;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;

public class ASN1BMPString
extends AbstractASN1CharacterString {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.UNIVERSAL, 30L);
    public static final ASN1Template TEMPLATE = new Template();

    public ASN1BMPString(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    public ASN1BMPString(String string) throws CharConversionException {
        super(string);
    }

    @Override
    protected CharConverter getCharConverter() {
        return new BMPConverter();
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public static ASN1BMPString getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1BMPString)ASN1Util.decode(TEMPLATE, byArray);
    }

    private static class BMPConverter
    implements CharConverter {
        private static final String ERROR_MESSAGE_1 = "Unable to find UnicodeBig encoding mechanism";
        private static final String ERROR_MESSAGE_2 = "Unable to find UnicodeBigUnmarked encoding mechanism";

        private BMPConverter() {
        }

        @Override
        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            try {
                String string = new String(byArray, n, n2, "UnicodeBig");
                return string.toCharArray();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.notReached(ERROR_MESSAGE_1);
                throw new CharConversionException(ERROR_MESSAGE_1);
            }
        }

        @Override
        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            try {
                String string = new String(cArray, n, n2);
                return string.getBytes("UnicodeBigUnmarked");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.notReached(ERROR_MESSAGE_2);
                throw new CharConversionException(ERROR_MESSAGE_2);
            }
        }
    }

    public static class Template
    extends AbstractASN1CharacterString.AbstractTemplate
    implements ASN1Template {
        @Override
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new BMPConverter();
        }

        @Override
        protected AbstractASN1CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new ASN1BMPString(cArray);
        }

        @Override
        protected String typeName() {
            return "ASN1BMPString";
        }
    }
}

