/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.AbstractASN1CharacterString;
import com.bifit.security.asn1.CharConverter;
import com.bifit.security.asn1.InvalidBERException;
import java.io.CharConversionException;

public class ASN1NumericString
extends AbstractASN1CharacterString {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.UNIVERSAL, 18L);
    public static final ASN1Template TEMPLATE = new Template();

    public ASN1NumericString(String string) throws CharConversionException {
        super(string);
    }

    protected ASN1NumericString(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    @Override
    protected CharConverter getCharConverter() {
        return new PrintableConverter();
    }

    public static ASN1NumericString getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1NumericString)ASN1Util.decode(TEMPLATE, byArray);
    }

    private static class PrintableConverter
    implements CharConverter {
        private static boolean[] isPrintable = new boolean[128];

        private PrintableConverter() {
        }

        @Override
        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            char[] cArray = new char[n2];
            int n3 = n;
            for (int i = 0; i < n2; ++i) {
                if ((byArray[n3] & 0x80) == 0 && isPrintable[byArray[n3]]) {
                    cArray[i] = (char)byArray[n3];
                }
                ++n3;
            }
            return cArray;
        }

        @Override
        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if ((cArray[n3] & 0xFF80) != 0 || !isPrintable[cArray[n3]]) {
                    throw new CharConversionException(cArray[n3] + " is not " + "a valid character for a NumericString");
                }
                byArray[n4] = (byte)(cArray[n3] & 0x7F);
                ++n4;
                ++n3;
            }
            return byArray;
        }

        static {
            for (int n = 48; n <= 57; n = (int)((char)(n + 1))) {
                PrintableConverter.isPrintable[n] = true;
            }
            PrintableConverter.isPrintable[32] = true;
        }
    }

    public static class Template
    extends AbstractASN1CharacterString.AbstractTemplate
    implements ASN1Template {
        @Override
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new PrintableConverter();
        }

        @Override
        protected AbstractASN1CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new ASN1NumericString(cArray);
        }

        @Override
        protected String typeName() {
            return "ASN1NumericString";
        }
    }
}

