/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.AbstractASN1CharacterString;
import com.bifit.security.asn1.CharConverter;
import com.bifit.security.asn1.InvalidBERException;
import java.io.CharConversionException;

public class ASN1PrintableString
extends AbstractASN1CharacterString {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.UNIVERSAL, 19L);
    public static final ASN1Template TEMPLATE = new Template();

    public ASN1PrintableString(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    public ASN1PrintableString(String string) throws CharConversionException {
        super(string);
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public static ASN1PrintableString getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1PrintableString)ASN1Util.decode(TEMPLATE, byArray);
    }

    @Override
    protected CharConverter getCharConverter() {
        return new PrintableConverter();
    }

    private static class PrintableConverter
    implements CharConverter {
        private static boolean[] isPrintable;

        private PrintableConverter() {
        }

        @Override
        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            char[] cArray = new char[n2];
            int n3 = n;
            for (int i = 0; i < n2; ++i) {
                if ((byArray[n3] & 0x80) == 0 && isPrintable[byArray[n3]]) {
                    cArray[i] = (char)byArray[n3];
                }
                ++n3;
            }
            return cArray;
        }

        @Override
        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if ((cArray[n3] & 0xFF80) != 0 || !isPrintable[cArray[n3]]) {
                    throw new CharConversionException(cArray[n3] + " is not " + "a valid character for a PrintableString");
                }
                byArray[n4] = (byte)(cArray[n3] & 0x7F);
                ++n4;
                ++n3;
            }
            return byArray;
        }

        static {
            int n;
            isPrintable = new boolean[128];
            for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
                PrintableConverter.isPrintable[n] = true;
            }
            for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
                PrintableConverter.isPrintable[n] = true;
            }
            for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
                PrintableConverter.isPrintable[n] = true;
            }
            PrintableConverter.isPrintable[32] = true;
            PrintableConverter.isPrintable[39] = true;
            PrintableConverter.isPrintable[40] = true;
            PrintableConverter.isPrintable[41] = true;
            PrintableConverter.isPrintable[43] = true;
            PrintableConverter.isPrintable[44] = true;
            PrintableConverter.isPrintable[45] = true;
            PrintableConverter.isPrintable[46] = true;
            PrintableConverter.isPrintable[47] = true;
            PrintableConverter.isPrintable[58] = true;
            PrintableConverter.isPrintable[61] = true;
            PrintableConverter.isPrintable[63] = true;
        }
    }

    public static class Template
    extends AbstractASN1CharacterString.AbstractTemplate
    implements ASN1Template {
        @Override
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new PrintableConverter();
        }

        @Override
        protected AbstractASN1CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new ASN1PrintableString(cArray);
        }

        @Override
        protected String typeName() {
            return "ASN1PrintableString";
        }
    }
}

