/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Set;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.CountingStream;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ASN1Sequence
extends ASN1Set {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.Class.UNIVERSAL, 16L);

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public static Template getSequenceTemplate() {
        return new Template();
    }

    public static OF_Template getSequenceTemplate(ASN1Template aSN1Template) {
        return new OF_Template(aSN1Template);
    }

    public static ASN1Sequence getInstance(ASN1Template aSN1Template, byte[] byArray) throws InvalidBERException {
        return (ASN1Sequence)ASN1Util.decode(aSN1Template, byArray);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.berEncode(aSN1Tag, outputStream);
    }

    public static class OF_Template
    implements ASN1Template {
        private Template template;

        private OF_Template() {
        }

        private void addElement(Template.Element element) {
            this.template.addElement(element);
        }

        public OF_Template(ASN1Template aSN1Template) {
            this.template = new Template();
            Template.Element element = new Template.Element(null, aSN1Template, true);
            element.makeRepeatable();
            this.template.addElement(element);
        }

        public static OF_Template makeOutputlessOFTemplate(ASN1Template aSN1Template) {
            OF_Template oF_Template = new OF_Template();
            oF_Template.template = new Template();
            Template.Element element = new Template.Element(null, aSN1Template, true, false);
            element.makeRepeatable();
            oF_Template.addElement(element);
            return oF_Template;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.template.decode(inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            return this.template.decode(aSN1Tag, inputStream);
        }
    }

    public static class Template
    implements ASN1Template {
        private final List<Element> elements = new ArrayList<Element>();

        private void addElement(Element element) {
            this.elements.add(element);
        }

        private void insertElementAt(Element element, int n) {
            this.elements.add(n, element);
        }

        public void addElement(ASN1Template aSN1Template) {
            this.addElement(new Element(null, aSN1Template, false));
        }

        public void insertElementAt(ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(null, aSN1Template, false), n);
        }

        public void addElement(ASN1Tag aSN1Tag, ASN1Template aSN1Template) {
            this.addElement(new Element(aSN1Tag, aSN1Template, false));
        }

        public void insertElementAt(ASN1Tag aSN1Tag, ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(aSN1Tag, aSN1Template, false), n);
        }

        public void addOptionalElement(ASN1Template aSN1Template) {
            this.addElement(new Element(null, aSN1Template, true));
        }

        public void insertOptionalElementAt(ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(null, aSN1Template, true), n);
        }

        public void addOptionalElement(ASN1Tag aSN1Tag, ASN1Template aSN1Template) {
            this.addElement(new Element(aSN1Tag, aSN1Template, true));
        }

        public void insertOptionalElementAt(ASN1Tag aSN1Tag, ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(aSN1Tag, aSN1Template, true), n);
        }

        public void addElement(ASN1Template aSN1Template, ASN1Value aSN1Value) {
            this.addElement(new Element(null, aSN1Template, aSN1Value));
        }

        public void insertElementAt(ASN1Template aSN1Template, ASN1Value aSN1Value, int n) {
            this.insertElementAt(new Element(null, aSN1Template, aSN1Value), n);
        }

        public void addElement(ASN1Tag aSN1Tag, ASN1Template aSN1Template, ASN1Value aSN1Value) {
            this.addElement(new Element(aSN1Tag, aSN1Template, aSN1Value));
        }

        public void insertElementAt(ASN1Tag aSN1Tag, ASN1Template aSN1Template, ASN1Value aSN1Value, int n) {
            this.insertElementAt(new Element(aSN1Tag, aSN1Template, aSN1Value), n);
        }

        public ASN1Tag implicitTagAt(int n) {
            return this.elements.get(n).getImplicitTag();
        }

        public ASN1Template templateAt(int n) {
            return this.elements.get(n).getTemplate();
        }

        public boolean isOptionalAt(int n) {
            return this.elements.get(n).isOptional();
        }

        public ASN1Value defaultAt(int n) {
            return this.elements.get(n).getDefault();
        }

        public int size() {
            return this.elements.size();
        }

        public void removeAllElements() {
            this.elements.clear();
        }

        public void removeElementAt(int n) {
            this.elements.remove(n);
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return aSN1Tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            int n = 0;
            try {
                Header header = new Header(inputStream);
                header.validate(aSN1Tag, ASN1Form.CONSTRUCTED);
                long l = header.getContentLength();
                boolean bl = false;
                ASN1Sequence aSN1Sequence = new ASN1Sequence();
                Header header2 = null;
                for (n = 0; n < this.size(); ++n) {
                    Object object;
                    if (l != 0L) {
                        header2 = Header.lookAhead(inputStream);
                    }
                    Element element = this.elements.get(n);
                    if (l == 0L || header2.isEOC() || !element.tagMatch(header2.getTag())) {
                        if (element.isRepeatable()) {
                            bl = true;
                            continue;
                        }
                        if (element.isOptional()) {
                            aSN1Sequence.addElement(null);
                            continue;
                        }
                        if (element.getDefault() == null) {
                            object = l == 0L ? "(null)" : header2.getTag().toString();
                            throw new InvalidBERException("Missing item #" + n + ": found " + (String)object);
                        }
                        aSN1Sequence.addElement(element.getDefault());
                        continue;
                    }
                    object = element.getTemplate();
                    CountingStream countingStream = new CountingStream(inputStream);
                    ASN1Value aSN1Value = element.getImplicitTag() == null ? object.decode(countingStream) : object.decode(element.getImplicitTag(), countingStream);
                    long l2 = countingStream.getNumRead();
                    if (l != -1L) {
                        if (l < l2) {
                            throw new InvalidBERException("Item went " + (l2 - l) + " bytes past the end of" + " the ASN1Sequence");
                        }
                        l -= l2;
                    }
                    if (element.producesOutput()) {
                        if (element.getImplicitTag() == null) {
                            aSN1Sequence.addElement(aSN1Value);
                        } else {
                            aSN1Sequence.addElement(element.getImplicitTag(), aSN1Value);
                        }
                    }
                    if (!element.isRepeatable()) continue;
                    bl = true;
                    --n;
                }
                if (l > 0L) {
                    throw new InvalidBERException("ASN1Sequence is " + l + " bytes longer than expected");
                }
                Assert.debugAssert(l == 0L || l == -1L);
                if (l == -1L && !(header2 = new Header(inputStream)).isEOC()) {
                    throw new InvalidBERException("No end-of-contents marker");
                }
                if (!bl) {
                    Assert.debugAssert(n == aSN1Sequence.size());
                }
                return aSN1Sequence;
            }
            catch (InvalidBERException invalidBERException) {
                invalidBERException.append("ASN1Sequence(item #" + n + ")");
                throw new InvalidBERException(invalidBERException, "ASN1Sequence");
            }
        }

        static class Element {
            private ASN1Tag implicitTag;
            private boolean doesProduceOutput = true;
            private final boolean optional;
            private final ASN1Template type;
            private ASN1Value defaultVal;
            private boolean repeatable;

            public Element(ASN1Tag aSN1Tag, ASN1Template aSN1Template, boolean bl) {
                this(aSN1Tag, aSN1Template, bl, true);
            }

            public Element(ASN1Tag aSN1Tag, ASN1Template aSN1Template, boolean bl, boolean bl2) {
                this.type = aSN1Template;
                this.optional = bl;
                this.implicitTag = aSN1Tag;
                this.doesProduceOutput = bl2;
            }

            public Element(ASN1Tag aSN1Tag, ASN1Template aSN1Template, ASN1Value aSN1Value) {
                this.type = aSN1Template;
                this.defaultVal = aSN1Value;
                this.optional = false;
                this.implicitTag = aSN1Tag;
            }

            private boolean producesOutput() {
                return this.doesProduceOutput;
            }

            private void makeRepeatable() {
                this.repeatable = true;
            }

            private boolean isRepeatable() {
                return this.repeatable;
            }

            public boolean isOptional() {
                return this.optional;
            }

            public ASN1Tag getImplicitTag() {
                return this.implicitTag;
            }

            public boolean tagMatch(ASN1Tag aSN1Tag) {
                if (this.implicitTag == null) {
                    return this.type.tagMatch(aSN1Tag);
                }
                return this.implicitTag.equals(aSN1Tag);
            }

            public ASN1Template getTemplate() {
                return this.type;
            }

            public ASN1Value getDefault() {
                return this.defaultVal;
            }
        }
    }
}

