/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.AbstractASN1CharacterString;
import com.bifit.security.asn1.CharConverter;
import com.bifit.security.asn1.InvalidBERException;
import java.io.CharConversionException;

public class ASN1TeletexString
extends AbstractASN1CharacterString {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.UNIVERSAL, 20L);
    public static final ASN1Template TEMPLATE = new Template();

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public ASN1TeletexString(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    public ASN1TeletexString(String string) throws CharConversionException {
        super(string);
    }

    @Override
    protected CharConverter getCharConverter() {
        return new TeletexConverter();
    }

    public static ASN1TeletexString getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1TeletexString)ASN1Util.decode(TEMPLATE, byArray);
    }

    private static class TeletexConverter
    implements CharConverter {
        private TeletexConverter() {
        }

        @Override
        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            char[] cArray = new char[n2];
            int n3 = n;
            for (int i = 0; i < n2; ++i) {
                cArray[i] = (char)(byArray[n3] & 0xFF);
                ++n3;
            }
            return cArray;
        }

        @Override
        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            int n4 = n;
            while (n3 < n2) {
                if ((cArray[n4] & 0xFF00) != 0) {
                    throw new CharConversionException("Invalid character for TeletexString");
                }
                byArray[n3] = (byte)(cArray[n4] & 0xFF);
                ++n3;
                ++n4;
            }
            return byArray;
        }
    }

    public static class Template
    extends AbstractASN1CharacterString.AbstractTemplate
    implements ASN1Template {
        @Override
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new TeletexConverter();
        }

        @Override
        protected AbstractASN1CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new ASN1TeletexString(cArray);
        }

        @Override
        protected String typeName() {
            return "ASN1TeletexString";
        }
    }
}

