/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class ASN1Util {
    private ASN1Util() {
    }

    public static byte[] encode(ASN1Value aSN1Value) {
        return ASN1Util.encode(aSN1Value.getTag(), aSN1Value);
    }

    public static byte[] encode(ASN1Tag aSN1Tag, ASN1Value aSN1Value) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1Value.encode(aSN1Tag, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Assert.notReached("Encoding to byte array gave IOException");
            return null;
        }
    }

    public static ASN1Value decode(ASN1Template aSN1Template, byte[] byArray) throws InvalidBERException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return aSN1Template.decode(byteArrayInputStream);
        }
        catch (IOException iOException) {
            Assert.notReached("Decoding from byte array gave IOException");
            return null;
        }
    }

    public static ASN1Value decode(ASN1Tag aSN1Tag, ASN1Template aSN1Template, byte[] byArray) throws InvalidBERException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return aSN1Template.decode(aSN1Tag, byteArrayInputStream);
        }
        catch (IOException iOException) {
            Assert.notReached("Decoding from byte array gave IOException");
            return null;
        }
    }

    public static void readFully(byte[] byArray, InputStream inputStream) throws IOException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw new EOFException();
        }
    }

    public static <T extends ASN1Value> T convertAnyType(ASN1Value aSN1Value, Class<T> clazz, ASN1Template aSN1Template) throws InvalidBERException {
        if (aSN1Value instanceof ASN1Any) {
            ASN1Any aSN1Any = (ASN1Any)aSN1Value;
            return (T)aSN1Any.decodeWith(aSN1Template);
        }
        if (clazz.isInstance(aSN1Value)) {
            return (T)aSN1Value;
        }
        throw new InvalidBERException("Invalid type. Expected " + clazz.getName() + ", actual " + aSN1Value.getClass().getName());
    }

    public static byte[] copy(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static char[] copy(char[] cArray) {
        int n = cArray.length;
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    public static long[] copy(long[] lArray) {
        int n = lArray.length;
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 0, lArray2, 0, n);
        return lArray2;
    }
}

