/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.CharConverter;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public abstract class AbstractASN1CharacterString
extends AbstractASN1Value {
    public static final ASN1Form FORM = ASN1Form.PRIMITIVE;
    private final char[] chars;
    private final byte[] cachedContents;

    protected abstract CharConverter getCharConverter();

    public String toString() {
        return new String(this.chars);
    }

    public char[] toCharArray() {
        return ASN1Util.copy(this.chars);
    }

    protected AbstractASN1CharacterString(char[] cArray) throws CharConversionException {
        this.chars = cArray;
        this.cachedContents = this.computeContents();
    }

    protected AbstractASN1CharacterString(String string) throws CharConversionException {
        this.chars = string.toCharArray();
        this.cachedContents = this.computeContents();
    }

    private byte[] getEncodedContents() {
        return this.cachedContents;
    }

    private byte[] computeContents() throws CharConversionException {
        CharConverter charConverter = this.getCharConverter();
        byte[] byArray = charConverter.charToByte(this.chars, 0, this.chars.length);
        return byArray;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        byte[] byArray = this.getEncodedContents();
        Header header = new Header(aSN1Tag, FORM, byArray.length);
        header.encode(outputStream);
        outputStream.write(byArray);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractASN1CharacterString)) {
            return false;
        }
        AbstractASN1CharacterString abstractASN1CharacterString = (AbstractASN1CharacterString)object;
        return this.getTag().equals(abstractASN1CharacterString.getTag()) && Arrays.equals(this.cachedContents, abstractASN1CharacterString.cachedContents);
    }

    public static abstract class AbstractTemplate
    implements ASN1Template {
        protected abstract ASN1Tag getTag();

        protected abstract CharConverter getCharConverter();

        protected abstract AbstractASN1CharacterString generateInstance(char[] var1) throws CharConversionException;

        protected abstract String typeName();

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                byte[] byArray;
                Object object;
                Header header = new Header(inputStream);
                header.validate(aSN1Tag);
                if (header.getContentLength() == -1L) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    do {
                        if (((Header)(object = Header.lookAhead(inputStream))).isEOC()) continue;
                        ASN1Template aSN1Template = ASN1OctetString.TEMPLATE;
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Template.decode(inputStream);
                        byteArrayOutputStream.write(aSN1OctetString.toByteArray());
                    } while (!((Header)object).isEOC());
                    object = new Header(inputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                } else {
                    byArray = new byte[(int)header.getContentLength()];
                    ASN1Util.readFully(byArray, inputStream);
                }
                object = this.getCharConverter().byteToChar(byArray, 0, byArray.length);
                return this.generateInstance((char[])object);
            }
            catch (CharConversionException charConversionException) {
                throw new InvalidBERException(charConversionException.getMessage());
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, this.typeName());
            }
        }
    }
}

